/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.blueprint;

import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.shelbie.core.internal.blueprint.BlueprintConverter;

public class BlueprintConverterTracker {
    private Map<ServiceReference, ServiceRegistration> converters;
    private BundleContext context;

    public BlueprintConverterTracker(BundleContext context) {
        this.context = context;
        this.converters = new Hashtable<ServiceReference, ServiceRegistration>();
    }

    @Bind(id="blueprint.converters", specification="org.osgi.service.blueprint.container.Converter")
    public void addBlueprintConverter(ServiceReference reference) {
        this.registerConverter(reference);
    }

    @Unbind(id="blueprint.converters", specification="org.osgi.service.blueprint.container.Converter")
    public void removeBlueprintConverter(ServiceReference reference) {
        this.unregisterConverter(reference);
    }

    private void unregisterConverter(ServiceReference reference) {
        ServiceRegistration reg = this.converters.get(reference);
        reg.unregister();
        this.converters.remove(reference);
    }

    private void registerConverter(ServiceReference reference) {
        Object converter = this.context.getService(reference);
        BlueprintConverter bpWrapper = new BlueprintConverter((org.osgi.service.blueprint.container.Converter)converter);
        ServiceRegistration reg = this.context.registerService(Converter.class.getName(), (Object)bpWrapper, null);
        this.converters.put(reference, reg);
    }
}

