/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.registry;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.Map;

public class RMIManageableSocketFactory
extends RMISocketFactory {
    private static RMISocketFactory factory = null;
    private Map<String, ServerSocket> exportedObjectfixedSocket = new HashMap<String, ServerSocket>();
    private Map<String, String> exportedObjectsPort = new HashMap<String, String>();
    private Map<String, String> mapPortProtocol = new HashMap<String, String>();
    private Map<String, InetAddress> inetAddress = new HashMap<String, InetAddress>();

    private RMIManageableSocketFactory(int port, InetAddress inetAddress) {
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket expss;
        String protocol = this.mapPortProtocol.get(Integer.toString(port));
        String key = null;
        if (protocol != null && port > 0 && (expss = this.exportedObjectfixedSocket.get(key = protocol + port)) != null) {
            return expss;
        }
        InetAddress ia = this.inetAddress.get(protocol);
        InetSocketAddress sa = ia == null ? new InetSocketAddress(port) : new InetSocketAddress(ia, port);
        ServerSocket ss = new ServerSocket();
        ss.setReuseAddress(true);
        ss.bind(sa);
        String strExpPort = this.exportedObjectsPort.get(protocol);
        int expPort = 0;
        if (strExpPort != null) {
            expPort = Integer.parseInt(strExpPort);
        }
        if (protocol != null && port > 0 && expPort == port) {
            this.exportedObjectfixedSocket.put(key, ss);
        }
        return ss;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    public static RMISocketFactory register(int port, int objectPort, InetAddress inetAddress, String protocol) throws RemoteException {
        if (factory == null) {
            factory = new RMIManageableSocketFactory(port, inetAddress);
            try {
                RMISocketFactory.setSocketFactory(factory);
            }
            catch (IOException ioe) {
                throw new RemoteException("Cannot set the default registry factory :", ioe);
            }
        }
        ((RMIManageableSocketFactory)factory).setPort(protocol, port, objectPort);
        ((RMIManageableSocketFactory)factory).setInetAddress(protocol, inetAddress);
        return factory;
    }

    public static RMISocketFactory getFactory() {
        return factory;
    }

    private void setPort(String protocol, int port, int objectPort) throws RemoteException {
        if (this.exportedObjectsPort.get(protocol) != null) {
            throw new RemoteException("Port already set for the protocol : " + objectPort + " " + protocol);
        }
        this.exportedObjectsPort.put(protocol, Integer.toString(objectPort));
        if (port > 0) {
            this.mapPortProtocol.put(Integer.toString(port), protocol);
        }
        if (objectPort > 0) {
            this.mapPortProtocol.put(Integer.toString(objectPort), protocol);
        }
    }

    private void setInetAddress(String protocol, InetAddress inetAddress) throws RemoteException {
        if (this.inetAddress.get(protocol) != null) {
            throw new RemoteException("Address already set for the protocol : " + inetAddress + " " + protocol);
        }
        this.inetAddress.put(protocol, inetAddress);
    }
}

