/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.registry;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import org.ow2.carol.jndi.registry.RMIManageableSocketFactory;

public class RegistryCreator {
    private RegistryCreator() {
    }

    public static Registry createRegistry(int port, int objectPort, InetAddress inetAddress, String protocol) throws RemoteException {
        if (objectPort > 0 || inetAddress != null) {
            RMISocketFactory socketFactory = RMIManageableSocketFactory.register(port, objectPort, inetAddress, protocol);
            return LocateRegistry.createRegistry(port, socketFactory, socketFactory);
        }
        return LocateRegistry.createRegistry(port);
    }

    public static void main(String[] args) {
        try {
            int regPort = 1099;
            if (args.length >= 1) {
                regPort = Integer.parseInt(args[0]);
            }
            RegistryCreator.createRegistry(regPort, 0, null, "irmi");
            System.out.println("Registry started on port " + regPort);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

