/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryNodeException;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.cache.lib.TupleCache;
import org.objectweb.medor.eval.cache.lib.WindowCachedTupleCollection;
import org.objectweb.medor.eval.lib.BinaryImplicitTC;
import org.objectweb.medor.eval.lib.CartesianEvaluatedTC;
import org.objectweb.medor.eval.lib.UnionEvaluatedTC;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.TupleCollection;

public class BinaryIteratifNodeEvaluator
implements NodeEvaluator {
    QueryNode query;
    NodeEvaluator leftNodeEvaluator;
    NodeEvaluator rightNodeEvaluator;
    EvaluationMetaData evaluationMetaData;
    long cacheSize;
    boolean open = false;

    public BinaryIteratifNodeEvaluator(QueryNode query, NodeEvaluator leftNodeEvaluator, NodeEvaluator rightNodeEvaluator, EvaluationMetaData evaluationMetaData) {
        this.query = query;
        this.leftNodeEvaluator = leftNodeEvaluator;
        this.rightNodeEvaluator = rightNodeEvaluator;
        this.evaluationMetaData = evaluationMetaData;
    }

    public boolean linkChildren() {
        return true;
    }

    public boolean unlinkChildren() {
        return true;
    }

    public TupleCollection fetchData(ParameterOperand[] parameters) throws MedorException {
        switch (this.query.getType()) {
            case 1: {
                if (this.evaluationMetaData == null) {
                    return new CartesianEvaluatedTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
                }
                if (this.evaluationMetaData.isCache()) {
                    return new WindowCachedTupleCollection(new CartesianEvaluatedTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters), new TupleCache(this.cacheSize));
                }
                return new CartesianEvaluatedTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
            }
            case 2: {
                if (this.evaluationMetaData == null) {
                    return new BinaryImplicitTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
                }
                if (this.evaluationMetaData.isCache()) {
                    return new WindowCachedTupleCollection(new BinaryImplicitTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters), new TupleCache(this.cacheSize));
                }
                return new BinaryImplicitTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
            }
            case 3: {
                if (this.evaluationMetaData == null) {
                    return new BinaryImplicitTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
                }
                if (this.evaluationMetaData.isCache()) {
                    return new WindowCachedTupleCollection(new BinaryImplicitTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters), new TupleCache(this.cacheSize));
                }
                return new BinaryImplicitTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
            }
            case 7: {
                if (this.evaluationMetaData == null) {
                    return new UnionEvaluatedTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
                }
                if (this.evaluationMetaData.isCache()) {
                    return new WindowCachedTupleCollection(new UnionEvaluatedTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters), new TupleCache(this.cacheSize));
                }
                return new UnionEvaluatedTC(this.query, this.leftNodeEvaluator, this.rightNodeEvaluator, parameters);
            }
        }
        throw new QueryNodeException("Unreconized QueryNode Type");
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public QueryNode getQueryNode() {
        return this.query;
    }

    public EvaluationMetaData getEvaluationMetaData() {
        return this.evaluationMetaData;
    }

    public void setPrefetchBuffer(PrefetchBuffer pb) throws MedorException {
    }
}

