/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.jk;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.jk.JkCluster;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;

public class JkClusterFactory
extends ClusterFactory {
    private JkCluster cluster = null;
    private boolean configSearched = false;

    public JkClusterFactory(DomainMonitor dm) {
        super(dm);
    }

    public BaseCluster getCluster(String name) {
        if (this.cluster != null && this.cluster.getName().equals(name)) {
            return this.cluster;
        }
        return null;
    }

    public boolean notifyServer(ServerProxy proxy) {
        ObjectName connectorOns;
        ObjectName engineOn;
        String serverName = proxy.getServerName();
        logger.log(BasicLevel.DEBUG, (Object)serverName);
        String workerName = null;
        try {
            engineOn = ObjectName.getInstance(this.domainName + ":type=Engine");
        }
        catch (MalformedObjectNameException e1) {
            logger.log(BasicLevel.WARN, (Object)e1);
            return false;
        }
        if (proxy.isRegistered(engineOn)) {
            logger.log(BasicLevel.DEBUG, (Object)"Found 1 engine. Look for jvmRoute");
            workerName = (String)proxy.getAttribute(engineOn, "jvmRoute");
        }
        if (workerName == null) {
            logger.log(BasicLevel.DEBUG, (Object)(serverName + " is not a JK-Cluster server"));
            return false;
        }
        if (!this.configSearched) {
            try {
                this.cluster = new JkCluster(this);
            }
            catch (Exception e) {
                logger.log(BasicLevel.DEBUG, (Object)("Unable to build jk cluster for " + workerName + " because " + e));
            }
        }
        if (this.cluster == null) {
            logger.log(BasicLevel.WARN, (Object)("Bad configuration: No workers.properties for " + workerName));
            return false;
        }
        this.configSearched = true;
        int workerPort = 0;
        try {
            connectorOns = ObjectName.getInstance(this.domainName + ":type=Connector,*");
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)e);
            return false;
        }
        for (ObjectName connectorOn : proxy.queryNames(connectorOns)) {
            String protocol = (String)proxy.getAttribute(connectorOn, "protocol");
            if (!"AJP/1.3".equals(protocol)) continue;
            workerPort = (Integer)proxy.getAttribute(connectorOn, "port");
            logger.log(BasicLevel.DEBUG, (Object)("Detected server has AJP Connector MBean with port=" + workerPort));
        }
        if (workerPort == 0) {
            logger.log(BasicLevel.WARN, (Object)"No AJP/1.3 protocol: forget it");
            return false;
        }
        return this.cluster.addWorker(workerName, workerPort, proxy);
    }

    public Collection getClusterList() {
        ArrayList<JkCluster> ret = new ArrayList<JkCluster>();
        if (this.cluster != null) {
            ret.add(this.cluster);
        }
        return ret;
    }

    public void getMonitoringInfo() {
    }
}

