/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMappingInfos;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;

public class RdbClassMultiMapping
extends RdbClassMapping
implements RdbMappingInfos {
    List tableNames = new ArrayList();
    List tables = new ArrayList();

    public RdbClassMultiMapping(String ruleName, MetaObject linkedMO, MetaObject parent) {
        super(ruleName, linkedMO, parent);
    }

    public PrimitiveElementMapping getPrimitiveElementMapping(String fieldName) {
        PrimitiveElementMapping pem = super.getPrimitiveElementMapping(fieldName);
        if (pem == null) {
            Iterator it = this.tables.iterator();
            while (pem == null && it.hasNext()) {
                pem = ((RdbExternalTable)it.next()).getPrimitiveElementMappingByField(fieldName);
            }
        }
        return pem;
    }

    public RdbExternalTable createRdbExternalTable(String tableName) {
        RdbExternalTable t;
        int idx = this.tableNames.indexOf(tableName);
        if (idx == -1) {
            t = new RdbExternalTable(this, this.getLinkedMO(), tableName);
            t.setLogger(this.getLogger());
            t.setLoggerFactory(this.getLoggerFactory());
            this.tableNames.add(tableName);
            this.tables.add(t);
        } else {
            t = (RdbExternalTable)this.tables.get(idx);
        }
        return t;
    }

    public RdbExternalTable removeRdbExternalTable(String tableName) {
        int idx = this.tableNames.indexOf(tableName);
        if (idx != -1) {
            this.tableNames.remove(idx);
            return (RdbExternalTable)this.tables.remove(idx);
        }
        return null;
    }

    public Collection getRdbExternalTables() {
        return this.tables;
    }

    public void getAllRdbExternalTables(ArrayList res) {
        if (!this.getParentClassMappings().isEmpty()) {
            Iterator it = this.getParentClassMappings().iterator();
            while (it.hasNext()) {
                ParentClassMapping pcm = (ParentClassMapping)it.next();
                if (pcm.getRuleName().equals("to-new-structures")) {
                    Class parentClass = pcm.getMOClass();
                    RdbClassMultiMapping classmapping = (RdbClassMultiMapping)parentClass.getClassMapping(this.getProjectName(), this.getMapperName());
                    classmapping.getAllRdbExternalTables(res);
                    res.addAll(this.tables);
                    continue;
                }
                res.addAll(this.getRdbExternalTables());
            }
        } else {
            res.addAll(this.tables);
        }
    }

    public RdbExternalTable getRdbExternalTable(String tableName) {
        int idx = this.tableNames.indexOf(tableName);
        if (idx != -1) {
            return (RdbExternalTable)this.tables.get(idx);
        }
        return null;
    }

    protected Collection getChildren() {
        Collection col = super.getChildren();
        col.addAll(this.tables);
        return col;
    }

    public RdbTable getMainTable() {
        return this.table;
    }

    public List getExternalTables() {
        return this.tables;
    }

    public List getExternalTableNames() {
        return this.tableNames;
    }
}

