/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ear.xml;

import org.ow2.jonas.deployment.common.CommonsSchemas;
import org.ow2.jonas.deployment.common.xml.AbsDescriptionElement;
import org.ow2.jonas.deployment.common.xml.DescriptionGroupXml;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;
import org.ow2.jonas.deployment.ear.EarSchemas;
import org.ow2.jonas.deployment.ear.xml.Module;

public class Application
extends AbsDescriptionElement
implements TopLevelElement,
DescriptionGroupXml {
    private String header = null;
    private JLinkedList moduleList = new JLinkedList("module");
    private JLinkedList securityRoleList = new JLinkedList("security-role");
    public static final String APPLICATION_ELEMENT = CommonsSchemas.getHeaderForStandardElement("application", EarSchemas.getLastSchema());

    public Application() {
        this.header = APPLICATION_ELEMENT;
    }

    public JLinkedList getModuleList() {
        return this.moduleList;
    }

    public void setModuleList(JLinkedList moduleList) {
        this.moduleList = moduleList;
    }

    public void addModule(Module module) {
        this.moduleList.add(module);
    }

    public JLinkedList getSecurityRoleList() {
        return this.securityRoleList;
    }

    public void setSecurityRoleList(JLinkedList securityRoleList) {
        this.securityRoleList = securityRoleList;
    }

    public void addSecurityRole(SecurityRole securityRole) {
        this.securityRoleList.add(securityRole);
    }

    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indent));
        if (this.header != null) {
            sb.append(this.header);
        } else {
            sb.append("<application>\n");
        }
        indent += 2;
        if (this.getIcon() != null) {
            sb.append(this.getIcon().toXML(indent));
        }
        if (this.getDisplayName() != null) {
            sb.append(this.xmlElement(this.getDisplayName(), "display-name", indent));
        }
        if (this.getDescription() != null) {
            sb.append(this.xmlElement(this.getDescription(), "description", indent));
        }
        sb.append(this.getModuleList().toXML(indent));
        sb.append(this.getSecurityRoleList().toXML(indent));
        sb.append(this.indent(indent -= 2));
        sb.append("</application>\n");
        return sb.toString();
    }
}

