/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.obr.activator;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.impl.obr.ObrResourceFetcherFactory;
import org.ow2.util.plan.repository.api.IRepositoryManager;

public class ObrFetcherActivator
implements BundleActivator,
ServiceListener {
    private Log logger = LogFactory.getLog(ObrFetcherActivator.class);
    private BundleContext bundleContext = null;
    private ObrResourceFetcherFactory fetcherFactory = null;
    private ServiceRegistration obrFetcherFactoryRegistration = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.fetcherFactory = new ObrResourceFetcherFactory();
        this.fetcherFactory.setBundleContext(this.bundleContext);
        ServiceReference repositoryManagerRef = context.getServiceReference(IRepositoryManager.class.getName());
        if (repositoryManagerRef != null) {
            this.fetcherFactory.setRepositoryManager((IRepositoryManager)context.getService(repositoryManagerRef));
        }
        this.obrFetcherFactoryRegistration = context.registerService(IResourceFetcherFactory.class.getName(), (Object)this.fetcherFactory, null);
        context.addServiceListener((ServiceListener)this, "(objectClass=" + IRepositoryManager.class.getName() + ")");
    }

    public void stop(BundleContext context) throws Exception {
        this.obrFetcherFactoryRegistration.unregister();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object serviceObject = this.bundleContext.getService(serviceRef);
        if (serviceObject instanceof IRepositoryManager) {
            IRepositoryManager repositoryManager = (IRepositoryManager)serviceObject;
            switch (event.getType()) {
                case 1: {
                    if (this.fetcherFactory.getRepositoryManager() != null) break;
                    this.fetcherFactory.setRepositoryManager(repositoryManager);
                    this.logger.debug((Object)"The repository manager is set to '{0}'.", new Object[]{repositoryManager});
                    break;
                }
                case 4: {
                    this.fetcherFactory.setRepositoryManager(null);
                    this.logger.debug((Object)"The repository manager is unset", new Object[0]);
                    break;
                }
            }
        }
    }
}

