/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.ha;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.cluster.ha.EjbHaClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.ha.EjbHaClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.ha.EjbHaClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.util.JonasObjectName;

public class EjbHaCluster
extends BaseCluster
implements EjbHaClusterMBean {
    protected String type = "EjbHaCluster";
    private String mcastAddr = null;
    private int mcastPort;

    public EjbHaCluster(EjbHaClusterFactory cf) throws JMException {
        super(cf);
    }

    public ClusterMember createClusterMember(String svname, ServerProxy proxy) {
        return new EjbHaClusterMember(svname, proxy);
    }

    public String getType() {
        return this.type;
    }

    public String getMcastAddr() {
        return this.mcastAddr;
    }

    public void setMcastAddr(String mcastAddr) {
        this.mcastAddr = mcastAddr;
    }

    public int getMcastPort() {
        return this.mcastPort;
    }

    public void setMcastPort(int mcastPort) {
        this.mcastPort = mcastPort;
    }

    public boolean addHaServer(String serverName, ServerProxy proxy) {
        EjbHaClusterMember ha = new EjbHaClusterMember(serverName, proxy);
        boolean added = this.addMember(ha);
        if (added) {
            try {
                ObjectName on = JonasObjectName.clusterMember((String)this.domainName, (String)serverName, (String)this.getType(), (String)this.name);
                ha.setObjectName(on);
                MBeanServer mbeanServer = this.jmx.getJmxServer();
                if (mbeanServer.isRegistered(on)) {
                    mbeanServer.unregisterMBean(on);
                }
                mbeanServer.registerMBean(ha, on);
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot register tomcat " + serverName + ": " + e));
            }
        }
        return added;
    }
}

