/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbInheritanceQuery;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.lib.BasicClassMapping;
import org.objectweb.jorm.metainfo.lib.BasicParentClassMapping;
import org.objectweb.jorm.metainfo.lib.FieldComparator;
import org.objectweb.jorm.naming.api.NamingFilterKeyProvider;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.ExpressionPrinter;
import org.objectweb.util.monolog.api.BasicLevel;

public class RdbClassMapping
extends BasicClassMapping {
    public static final String MAP_NEW_FIELDS_TO_EXTENDED_STRUCTURES = "to-extended-structures";
    public static final String MAP_NEW_FIELDS_TO_ADDED_STRUCTURES = "to-added-structures";
    public static final String REMAP_FIELDS_TO_NEW_STRUCTURES = "to-new-structures";
    RdbTable table = null;
    RdbFilter filter = null;
    RdbInheritanceQuery inheritanceQuery = null;

    public RdbClassMapping(String ruleName, MetaObject linkedMO, MetaObject parent) {
        super(ruleName, linkedMO, parent);
    }

    public List getAllPrimitiveElementMappings() {
        int i;
        List pems = super.getAllPrimitiveElementMappings();
        List pcms = (List)this.getParentClassMappings();
        for (i = pcms.size() - 1; i >= 0; --i) {
            Mapping m;
            Class superClass;
            ClassProject cp;
            ParentClassMapping pcm = (ParentClassMapping)pcms.get(i);
            if (!MAP_NEW_FIELDS_TO_EXTENDED_STRUCTURES.equalsIgnoreCase(pcm.getRuleName()) && !MAP_NEW_FIELDS_TO_ADDED_STRUCTURES.equalsIgnoreCase(pcm.getRuleName()) || (cp = (superClass = pcm.getMOClass()).getClassProject(this.getProjectName())) == null || (m = cp.getMapping(this.getMapperName())) == null) continue;
            pems.addAll(m.getClassMapping().getAllPrimitiveElementMappings());
        }
        if (i == -1) {
            Collections.sort(pems, FieldComparator.instance);
        }
        return pems;
    }

    public RdbTable createRdbTable(String tableName) {
        if (this.table == null) {
            this.table = new RdbTable(this, this.getLinkedMO(), tableName);
            this.table.setLogger(this.getLogger());
            this.table.setLoggerFactory(this.getLoggerFactory());
        } else {
            this.table.setName(tableName);
        }
        return this.table;
    }

    public RdbTable getRdbTable() {
        return this.table;
    }

    public void getMainRdbTableOld(ArrayList res) {
        if (!this.getParentClassMappings().isEmpty()) {
            Iterator it = this.getParentClassMappings().iterator();
            while (it.hasNext()) {
                ParentClassMapping pcm = (ParentClassMapping)it.next();
                String ruleName = pcm.getRuleName();
                if (MAP_NEW_FIELDS_TO_ADDED_STRUCTURES.equals(ruleName) || MAP_NEW_FIELDS_TO_EXTENDED_STRUCTURES.equals(ruleName)) {
                    Class parentClass = pcm.getMOClass();
                    RdbClassMapping classmapping = (RdbClassMapping)parentClass.getClassMapping(this.getProjectName(), this.getMapperName());
                    classmapping.getMainRdbTableOld(res);
                    continue;
                }
                res.add(this.table);
            }
        } else {
            res.add(this.table);
        }
    }

    public RdbTable getMainRdbTable() {
        if (this.table == null) {
            ParentClassMapping aPcm = (ParentClassMapping)this.parentClassMappings.get(0);
            Class aSuperClass = aPcm.getMOClass();
            RdbClassMapping aSuperCm = (RdbClassMapping)aSuperClass.getClassMapping(this.getProjectName(), this.getMapperName());
            this.table = aSuperCm.getMainRdbTable();
        }
        return this.table;
    }

    public RdbFilter createRdbFilter() {
        this.filter = new RdbFilter(this);
        return this.filter;
    }

    public RdbFilter getRdbFilter() {
        return this.filter;
    }

    public RdbInheritanceQuery getRdbInheritanceQuery() {
        if (this.inheritanceQuery == null) {
            this.createRdbInheritanceQuery();
        }
        return this.inheritanceQuery;
    }

    public RdbInheritanceQuery createRdbInheritanceQuery() {
        if (this.inheritanceQuery == null) {
            this.inheritanceQuery = new RdbInheritanceQuery(this);
        }
        return this.inheritanceQuery;
    }

    public Expression getMappingFilterFromNamingFilter() throws ExpressionException {
        return this.getMappingFilterFromNamingFilter(null);
    }

    public Expression getMappingFilterFromNamingFilter(NamingFilterKeyProvider nfkp) throws ExpressionException {
        NameDef nd;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getMappingFilterFromNamingFilter: class " + ((Class)this.linkedMO).getFQName()));
        }
        if ((nd = this.getIdentifierMapping().getNameDef()) == null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"getMappingFilterFromNamingFilter: null NameDef");
            }
            return null;
        }
        Class clazz = this.getJormClass();
        Expression namingFilter = null;
        namingFilter = clazz.getInheritanceFilter(nd);
        Object key = nfkp != null ? nfkp.getNamingFilterKey() : clazz.getInheritanceNamingKey(nd);
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getMappingFilterFromNamingFilter: key=" + key + " / namingFilter=" + namingFilter));
        }
        if (key != null) {
            if (namingFilter == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Find the naming filter on ancestors");
                ArrayList al = new ArrayList(clazz.getSuperClasses());
                while (namingFilter == null && !al.isEmpty()) {
                    Class superClass = (Class)al.remove(0);
                    this.logger.log(BasicLevel.DEBUG, (Object)("Ancestor " + superClass.getFQName()));
                    namingFilter = superClass.getInheritanceFilter(nd);
                    if (namingFilter != null) continue;
                    al.addAll(superClass.getSuperClasses());
                }
                if (namingFilter == null) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"No the naming filter found on ancestors");
                    return null;
                }
                this.logger.log(BasicLevel.DEBUG, (Object)("Naming filter found on ancestors: " + ExpressionPrinter.e2str(namingFilter)));
            }
            this.logger.log(BasicLevel.DEBUG, (Object)"Compute the key filter with key value");
            BasicVariableOperand keyexp = new BasicVariableOperand(namingFilter.getType());
            if (key instanceof String) {
                this.assignKey(keyexp, (String)key);
            } else {
                keyexp.setValue(key);
            }
            namingFilter = new Equal(keyexp, namingFilter);
            this.logger.log(BasicLevel.DEBUG, (Object)("Naming filter changed into Equal: " + ExpressionPrinter.e2str(namingFilter)));
        } else if (namingFilter == null) {
            return null;
        }
        Expression res = this.cloneAndReplaceLeaves(namingFilter);
        if (this.debug) {
            this.logger.log(BasicLevel.WARN, (Object)("Filter=" + ExpressionPrinter.e2str(res)));
        }
        return res;
    }

    private void assignKey(BasicVariableOperand keyexp, String str) throws ExpressionException {
        switch (keyexp.getType().getTypeCode()) {
            case 2: {
                keyexp.setValue(Byte.parseByte(str));
                break;
            }
            case 1: {
                keyexp.setValue(str.charAt(0));
                break;
            }
            case 3: {
                keyexp.setValue(Short.parseShort(str));
                break;
            }
            case 4: {
                keyexp.setValue(Integer.parseInt(str));
                break;
            }
            case 5: {
                keyexp.setValue(Long.parseLong(str));
                break;
            }
            case 10: {
                keyexp.setValue(Long.valueOf(str));
                break;
            }
            case 9: {
                keyexp.setValue(new Character(str.charAt(0)));
                break;
            }
            case 11: {
                keyexp.setValue(Short.valueOf(str));
                break;
            }
            case 12: {
                keyexp.setValue(Integer.valueOf(str));
                break;
            }
            case 13: {
                keyexp.setValue(Long.valueOf(str));
                break;
            }
            case 17: {
                try {
                    keyexp.setValue(DateFormat.getInstance().parse(str));
                    break;
                }
                catch (ParseException e) {
                    throw new ExpressionException("Impossible to parse the date " + str, e);
                }
            }
            case 16: {
                keyexp.setValue(str);
                break;
            }
            case 22: {
                keyexp.setValue(new BigDecimal(str));
                break;
            }
            case 21: {
                keyexp.setValue(new BigInteger(str));
                break;
            }
            default: {
                throw new ExpressionException("Umanaged key type: " + keyexp.getType().getJavaName());
            }
        }
    }

    private Expression cloneAndReplaceLeaves(Expression exp) throws ExpressionException {
        if (exp instanceof ParameterOperand) {
            NameDef nd = this.getIdentifierMapping().getNameDef();
            String classFieldName = null;
            if (nd.isFieldName()) {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("nd.getFieldName = " + nd.getFieldName() + " while exp.getName = " + ((ParameterOperand)exp).getName()));
                }
                return exp;
            }
            if (nd.isNameRef()) {
                classFieldName = (String)nd.getNameRef().getProjection().get(((ParameterOperand)exp).getName());
                if (classFieldName == null) {
                    return exp;
                }
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("nref.getFieldName = " + classFieldName + " while exp.getName = " + ((ParameterOperand)exp).getName()));
                }
            } else {
                throw new ExpressionException("Naming type not managed: " + nd);
            }
            return new BasicParameterOperand(exp.getType(), classFieldName);
        }
        if (exp instanceof BasicVariableOperand) {
            return new BasicVariableOperand((BasicOperand)exp);
        }
        if (exp instanceof BasicOperand) {
            return new BasicOperand((BasicOperand)exp);
        }
        if (exp instanceof Operator) {
            Operator oldop = (Operator)exp;
            Operator newop = null;
            try {
                newop = (Operator)exp.getClass().newInstance();
            }
            catch (Exception e) {
                throw new ExpressionException("Impossible to clone the operator " + exp.getClass().getName() + ": ", e);
            }
            for (int i = oldop.getOperandNumber() - 1; i >= 0; --i) {
                newop.setExpression(i, this.cloneAndReplaceLeaves(oldop.getExpression(i)));
            }
            return newop;
        }
        throw new ExpressionException("UnManaged expression: " + exp);
    }

    protected Collection getChildren() {
        Collection col = super.getChildren();
        if (this.table != null) {
            col.add(this.table);
        }
        return col;
    }

    public ParentClassMapping createImplicitParentClassMapping(Class superClass) {
        BasicParentClassMapping pcm = new BasicParentClassMapping(MAP_NEW_FIELDS_TO_EXTENDED_STRUCTURES, superClass, this);
        this.addParentClassMapping(pcm);
        return pcm;
    }

    public void addImplicitDependencies() {
        Class clazz = (Class)this.getLinkedMO();
        Iterator itPcm = this.getParentClassMappings().iterator();
        while (itPcm.hasNext()) {
            ParentClassMapping parentClassMapping = (ParentClassMapping)itPcm.next();
            if (!this.inheritsStructures(parentClassMapping)) continue;
            Class superClass = (Class)parentClassMapping.getLinkedMO();
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Add dependency: " + clazz.getName() + " -> " + superClass.getName()));
            }
            this.addDependency(superClass.getFQName());
        }
        Iterator itClass = clazz.getSubClasses().iterator();
        while (itClass.hasNext()) {
            Class subClass = (Class)itClass.next();
            ClassMapping subClassMapping = subClass.getClassMapping(this.getProjectName(), this.getMapperName());
            if (subClassMapping == null) {
                throw new InternalError("Cannot find class mapping of " + subClass.getName() + "<" + this.getProjectName() + "," + this.getMapperName() + ">" + " when adding implicit dependencies to " + clazz.getName());
            }
            ParentClassMapping parentClassMapping = subClassMapping.getParentClassMapping(clazz.getFQName());
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Add dependency: " + clazz.getName() + " -> " + subClass.getName()));
            }
            this.addDependency(subClass.getFQName());
        }
    }

    public boolean hasUnmappedPrimitiveElements(Collection pes) {
        Class clazz = (Class)this.linkedMO;
        Iterator itPE = pes.iterator();
        while (itPE.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)itPE.next();
            PrimitiveElementMapping pem = this.getPrimitiveElementMapping(pe.getName(), true);
            if (pem != null) continue;
            return true;
        }
        return false;
    }

    public Set getParentClassMapping(Set inheritanceRules) {
        HashSet<ParentClassMapping> res = new HashSet<ParentClassMapping>();
        Iterator it = this.parentClassMappings.iterator();
        while (it.hasNext()) {
            ParentClassMapping pcm = (ParentClassMapping)it.next();
            if (!inheritanceRules.contains(pcm.getRuleName())) continue;
            res.add(pcm);
        }
        return res;
    }

    public Set getAddedOrExtendedParentClassMapping() {
        HashSet<ParentClassMapping> res = new HashSet<ParentClassMapping>();
        Iterator it = this.parentClassMappings.iterator();
        while (it.hasNext()) {
            ParentClassMapping pcm = (ParentClassMapping)it.next();
            if (!this.inheritsStructures(pcm)) continue;
            res.add(pcm);
        }
        return res;
    }

    public boolean inheritsStructures(ParentClassMapping pcm) {
        return MAP_NEW_FIELDS_TO_EXTENDED_STRUCTURES.equalsIgnoreCase(pcm.getRuleName()) || MAP_NEW_FIELDS_TO_ADDED_STRUCTURES.equalsIgnoreCase(pcm.getRuleName());
    }

    public boolean inheritsStructures() {
        Iterator it = this.getParentClassMappings().iterator();
        while (it.hasNext()) {
            ParentClassMapping pcm = (ParentClassMapping)it.next();
            if (!this.inheritsStructures(pcm)) continue;
            return true;
        }
        return false;
    }

    public PrimitiveElementMapping getPrimitiveElementMapping(String fieldName, boolean searchInSuper) {
        PrimitiveElementMapping pem;
        block1: {
            Class superClass;
            BasicClassMapping superClassMapping;
            ParentClassMapping pcm;
            pem = this.getPrimitiveElementMapping(fieldName);
            if (pem != null || !searchInSuper) break block1;
            Mapping mapping = (Mapping)this.getParent();
            String mapperName = mapping.getMapperName();
            String projectName = ((ClassProject)mapping.getParent()).getProjectName();
            Iterator itPcm = this.parentClassMappings.iterator();
            while (itPcm.hasNext() && (REMAP_FIELDS_TO_NEW_STRUCTURES.equals((pcm = (ParentClassMapping)itPcm.next()).getRuleName()) || (pem = (superClassMapping = (BasicClassMapping)(superClass = (Class)pcm.getLinkedMO()).getClassMapping(projectName, mapperName)).getPrimitiveElementMapping(fieldName, searchInSuper)) == null)) {
            }
        }
        return pem;
    }
}

