/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Iterator;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.SecurityRoleRefDesc;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.ExcludeListDesc;
import org.ow2.jonas.deployment.ejb.MethodPermissionDesc;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.security.AbsPermissionManager;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.lib.security.auth.JPrincipal;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandlerCurrent;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandlerData;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;

public class PermissionManager
extends AbsPermissionManager {
    private DeploymentDesc ejbDeploymentDesc = null;

    public PermissionManager(DeploymentDesc ejbDeploymentDesc, String contextId) throws PermissionManagerException {
        super(contextId);
        this.ejbDeploymentDesc = ejbDeploymentDesc;
    }

    public void translateEjbDeploymentDescriptor() throws PermissionManagerException {
        this.translateEjbMethodPermission();
        this.translateEjbExcludeList();
        this.translateEjbSecurityRoleRef();
    }

    protected void translateEjbMethodPermission() throws PermissionManagerException {
        if (this.ejbDeploymentDesc == null || this.getPolicyConfiguration() == null) {
            throw new PermissionManagerException("PolicyConfiguration or ejbDeploymentDesc is null");
        }
        MethodPermissionDesc methodPermissionDesc2 = null;
        PermissionCollection permissionCollection = null;
        for (MethodPermissionDesc methodPermissionDesc2 : this.ejbDeploymentDesc.getMethodPermissionsDescList()) {
            permissionCollection = methodPermissionDesc2.getEJBMethodPermissions();
            try {
                if (methodPermissionDesc2.isUnchecked()) {
                    this.getPolicyConfiguration().addToUncheckedPolicy(permissionCollection);
                    continue;
                }
                Iterator rolesIt = methodPermissionDesc2.getRoleNameList().iterator();
                while (rolesIt.hasNext()) {
                    this.getPolicyConfiguration().addToRole((String)rolesIt.next(), permissionCollection);
                }
            }
            catch (PolicyContextException pce) {
                throw new PermissionManagerException("Can not add add excluded policy", (Throwable)pce);
            }
        }
    }

    protected void translateEjbExcludeList() throws PermissionManagerException {
        if (this.ejbDeploymentDesc == null || this.getPolicyConfiguration() == null) {
            throw new PermissionManagerException("PolicyConfiguration or ejbDeploymentDesc is null");
        }
        ExcludeListDesc excludeListDesc = this.ejbDeploymentDesc.getExcludeListDesc();
        if (excludeListDesc != null) {
            try {
                this.getPolicyConfiguration().addToExcludedPolicy(excludeListDesc.getEJBMethodPermissions());
            }
            catch (PolicyContextException pce) {
                throw new PermissionManagerException("Can not add add excluded policy", (Throwable)pce);
            }
        }
    }

    public void translateEjbSecurityRoleRef() throws PermissionManagerException {
        if (this.ejbDeploymentDesc == null || this.getPolicyConfiguration() == null) {
            throw new PermissionManagerException("PolicyConfiguration or ejbDeploymentDesc is null");
        }
        SecurityRoleRefDesc securityRoleRefDesc2 = null;
        BeanDesc beanDesc = null;
        Iterator itEjb = this.ejbDeploymentDesc.getBeanDescIterator();
        while (itEjb.hasNext()) {
            beanDesc = (BeanDesc)itEjb.next();
            for (SecurityRoleRefDesc securityRoleRefDesc2 : beanDesc.getSecurityRoleRefDescList()) {
                try {
                    this.getPolicyConfiguration().addToRole(securityRoleRefDesc2.getRoleLink(), securityRoleRefDesc2.getEJBRoleRefPermission());
                }
                catch (PolicyContextException pce) {
                    throw new PermissionManagerException("Can not add add excluded policy", (Throwable)pce);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSecurity(String ejbName, EJBInvocation ejbInv, boolean inRunAs) {
        try {
            JPolicyContextHandlerData jPolicyContextHandlerData;
            PolicyContext.setContextID((String)this.getContextId());
            String methodSignature = ejbInv.methodPermissionSignature;
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("EjbName = " + ejbName + ", methodSignature = " + methodSignature));
            }
            if ((jPolicyContextHandlerData = JPolicyContextHandlerCurrent.getCurrent().getJPolicyContextHandlerData()) == null) {
                TraceEjb.security.log(BasicLevel.ERROR, (Object)"The Handler data retrieved is null !");
                return false;
            }
            jPolicyContextHandlerData.setEjbArguments(ejbInv.arguments);
            jPolicyContextHandlerData.setProcessingBean(ejbInv.bean);
            PolicyContext.setHandlerData((Object)jPolicyContextHandlerData);
            URI uri = new URI("file://" + this.getContextId());
            CodeSource codesource = new CodeSource(new URL(uri.toString()), (Certificate[])null);
            SecurityCurrent current = SecurityCurrent.getCurrent();
            SecurityContext sctx = current.getSecurityContext();
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("Security Context = " + sctx));
                if (sctx != null) {
                    TraceEjb.security.log(BasicLevel.DEBUG, (Object)("sctx.getCallerPrincipalRoles() = " + sctx.getCallerPrincipalRoles(inRunAs)));
                }
            }
            String[] overridedRoles = null;
            if (!inRunAs) {
                overridedRoles = JPolicyUserRoleMapping.getMappingForPrincipal((String)this.getContextId(), (String)sctx.getPrincipalName());
            }
            String runAsRole = null;
            Principal[] principals = null;
            String[] runAsPrincipalRoles = null;
            String[] principalRoles = null;
            if (sctx != null) {
                int k;
                SecurityContext securityContext = sctx;
                synchronized (securityContext) {
                    runAsRole = sctx.peekRunAsRole();
                    runAsPrincipalRoles = sctx.peekRunAsPrincipalRoles();
                    principalRoles = sctx.getCallerPrincipalRoles(inRunAs);
                }
                if (runAsRole != null) {
                    principals = new Principal[runAsPrincipalRoles.length];
                    for (k = 0; k < runAsPrincipalRoles.length; ++k) {
                        principals[k] = new JPrincipal(runAsPrincipalRoles[k]);
                    }
                } else if (overridedRoles != null) {
                    principals = new Principal[overridedRoles.length];
                    for (k = 0; k < overridedRoles.length; ++k) {
                        principals[k] = new JPrincipal(overridedRoles[k]);
                    }
                } else {
                    principals = new Principal[principalRoles.length];
                    for (k = 0; k < principalRoles.length; ++k) {
                        principals[k] = new JPrincipal(principalRoles[k]);
                    }
                }
            } else if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)"Security context is null");
            }
            ProtectionDomain protectionDomain = new ProtectionDomain(codesource, null, null, principals);
            EJBMethodPermission ejbMethodPermission = new EJBMethodPermission(ejbName, methodSignature);
            boolean accessOK = PermissionManager.getPolicy().implies(protectionDomain, (Permission)ejbMethodPermission);
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("Policy.implies result = " + accessOK));
            }
            jPolicyContextHandlerData = null;
            return accessOK;
        }
        catch (Exception e) {
            TraceEjb.security.log(BasicLevel.ERROR, (Object)"Cannot check security", (Throwable)e);
            return false;
        }
    }

    public boolean isCallerInRole(String ejbName, String roleName, boolean inRunAs) {
        try {
            PolicyContext.setContextID((String)this.getContextId());
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("roleName = " + roleName));
            }
            URI uri = new URI("file://" + this.getContextId());
            CodeSource codesource = new CodeSource(new URL(uri.toString()), (Certificate[])null);
            SecurityCurrent current = SecurityCurrent.getCurrent();
            SecurityContext sctx = current.getSecurityContext();
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("Security Context = " + sctx));
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("sctx.getCallerPrincipalRoles() = " + sctx.getCallerPrincipalRoles(inRunAs)));
            }
            Principal[] principals = null;
            if (sctx != null) {
                principals = new Principal[sctx.getCallerPrincipalRoles(inRunAs).length];
                for (int k = 0; k < sctx.getCallerPrincipalRoles(inRunAs).length; ++k) {
                    principals[k] = new JPrincipal(sctx.getCallerPrincipalRoles(inRunAs)[k]);
                }
            } else if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)"Security context is null");
            }
            ProtectionDomain protectionDomain = new ProtectionDomain(codesource, null, null, principals);
            EJBRoleRefPermission ejbRoleRefPermission = new EJBRoleRefPermission(ejbName, roleName);
            boolean isInRole = PermissionManager.getPolicy().implies(protectionDomain, (Permission)ejbRoleRefPermission);
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.security.log(BasicLevel.DEBUG, (Object)("Policy.implies result = " + isInRole));
            }
            return isInRole;
        }
        catch (Exception e) {
            TraceEjb.security.log(BasicLevel.ERROR, (Object)"Cannot check isCallerInRole", (Throwable)e);
            return false;
        }
    }

    protected void resetDeploymentDesc() {
        this.ejbDeploymentDesc = null;
    }
}

