/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.PrimitiveInstanceDescription;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class Dependency
implements HandlerConfiguration {
    public static final int DYNAMIC = 0;
    public static final int STATIC = 1;
    public static final int DYNAMIC_PRIORITY = 2;
    private String m_specification;
    private String m_filter;
    private String m_field;
    private boolean m_optional;
    private boolean m_aggregate;
    private String m_bind;
    private String m_unbind;
    private String m_modified;
    private int m_policy;
    private String m_comparator;
    private String m_di;
    private String m_from;
    private String m_id;
    private boolean m_nullable = true;
    private boolean m_proxy = true;

    public Element getElement() {
        Element cb;
        this.ensureValidity();
        Element dep = new Element("requires", "");
        if (this.m_specification != null) {
            dep.addAttribute(new Attribute("specification", this.m_specification));
        }
        if (this.m_filter != null) {
            dep.addAttribute(new Attribute("filter", this.m_filter));
        }
        if (this.m_field != null) {
            dep.addAttribute(new Attribute("field", this.m_field));
        }
        if (this.m_bind != null) {
            cb = new Element("callback", "");
            cb.addAttribute(new Attribute("type", "bind"));
            cb.addAttribute(new Attribute("method", this.m_bind));
            dep.addElement(cb);
        }
        if (this.m_unbind != null) {
            cb = new Element("callback", "");
            cb.addAttribute(new Attribute("type", "unbind"));
            cb.addAttribute(new Attribute("method", this.m_unbind));
            dep.addElement(cb);
        }
        if (this.m_modified != null) {
            cb = new Element("callback", "");
            cb.addAttribute(new Attribute("type", "modified"));
            cb.addAttribute(new Attribute("method", this.m_modified));
            dep.addElement(cb);
        }
        if (this.m_comparator != null) {
            dep.addAttribute(new Attribute("comparator", this.m_comparator));
        }
        if (this.m_di != null) {
            dep.addAttribute(new Attribute("default-implementation", this.m_di));
        }
        if (this.m_from != null) {
            dep.addAttribute(new Attribute("from", this.m_from));
        }
        if (this.m_id != null) {
            dep.addAttribute(new Attribute("id", this.m_id));
        }
        if (!this.m_nullable) {
            dep.addAttribute(new Attribute("nullable", "false"));
        }
        if (this.m_optional) {
            dep.addAttribute(new Attribute("optional", "true"));
        }
        if (this.m_aggregate) {
            dep.addAttribute(new Attribute("aggregate", "true"));
        }
        if (!this.m_proxy) {
            dep.addAttribute(new Attribute("proxy", "false"));
        }
        if (this.m_policy != -1) {
            if (this.m_policy == 0) {
                dep.addAttribute(new Attribute("policy", "dynamic"));
            } else if (this.m_policy == 1) {
                dep.addAttribute(new Attribute("policy", "static"));
            } else if (this.m_policy == 2) {
                dep.addAttribute(new Attribute("policy", "dynamic-priority"));
            }
        }
        return dep;
    }

    public Dependency setSpecification(String spec) {
        this.m_specification = spec;
        return this;
    }

    public Dependency setFilter(String filter) {
        this.m_filter = filter;
        return this;
    }

    public Dependency setField(String field) {
        this.m_field = field;
        return this;
    }

    public Dependency setOptional(boolean opt) {
        this.m_optional = opt;
        return this;
    }

    public Dependency setAggregate(boolean agg) {
        this.m_aggregate = agg;
        return this;
    }

    public Dependency setNullable(boolean nullable) {
        this.m_nullable = nullable;
        return this;
    }

    public Dependency setProxy(boolean proxy) {
        this.m_proxy = proxy;
        return this;
    }

    public Dependency setBindMethod(String bind) {
        this.m_bind = bind;
        return this;
    }

    public Dependency setUnbindMethod(String unbind) {
        this.m_unbind = unbind;
        return this;
    }

    public Dependency setModifiedMethod(String modified) {
        this.m_modified = modified;
        return this;
    }

    public Dependency setBindingPolicy(int policy) {
        this.m_policy = policy;
        return this;
    }

    public Dependency setComparator(String cmp) {
        this.m_comparator = cmp;
        return this;
    }

    public Dependency setDefaultImplementation(String di) {
        this.m_di = di;
        return this;
    }

    public Dependency setFrom(String from) {
        this.m_from = from;
        return this;
    }

    public Dependency setId(String id) {
        this.m_id = id;
        return this;
    }

    private void ensureValidity() {
        if (this.m_field == null && this.m_bind == null && this.m_unbind == null) {
            throw new IllegalStateException("A dependency must have a field or bind/unbind methods");
        }
        if (this.m_policy != -1 && this.m_policy != 0 && this.m_policy != 1 && this.m_policy != 2) {
            throw new IllegalStateException("Unknow binding policy : " + this.m_policy);
        }
    }

    public DependencyDescription getDependencyDescription(ComponentInstance instance) {
        PrimitiveInstanceDescription desc = (PrimitiveInstanceDescription)instance.getInstanceDescription();
        if (this.m_id != null) {
            return desc.getDependency(this.m_id);
        }
        if (this.m_specification != null) {
            return desc.getDependency(this.m_specification);
        }
        DependencyDescription[] deps = desc.getDependencies();
        if (deps.length == 1) {
            return deps[0];
        }
        return null;
    }
}

