/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.component;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceConstructor;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.spi.component.ResourceComponentInjector;
import com.sun.jersey.spi.inject.Errors;
import com.sun.jersey.spi.inject.Injectable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class ResourceComponentConstructor {
    private final Class c;
    private final ResourceComponentInjector rci;
    private final Constructor constructor;
    private final List<Method> postConstructs = new ArrayList<Method>();
    private final List<AbstractHttpContextInjectable> injectables;

    public ResourceComponentConstructor(ServerInjectableProviderContext sipc, ComponentScope scope, AbstractResource ar) {
        this.c = ar.getResourceClass();
        int modifiers = this.c.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            Errors.nonPublicClass(this.c);
        }
        if (Modifier.isAbstract(modifiers)) {
            if (Modifier.isInterface(modifiers)) {
                Errors.interfaceClass(this.c);
            } else {
                Errors.abstractClass(this.c);
            }
        }
        if (this.c.getEnclosingClass() != null && !Modifier.isStatic(modifiers)) {
            Errors.innerClass(this.c);
        }
        if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && this.c.getConstructors().length == 0) {
            Errors.nonPublicConstructor(this.c);
        }
        this.rci = new ResourceComponentInjector(sipc, scope, ar);
        this.postConstructs.addAll(ar.getPostConstructMethods());
        ConstructorInjectablePair cip = this.getConstructor(sipc, scope, ar);
        if (cip == null) {
            this.constructor = null;
            this.injectables = null;
        } else if (cip.is.isEmpty()) {
            this.constructor = cip.con;
            this.injectables = null;
        } else {
            if (cip.is.contains(null)) {
                for (int i = 0; i < cip.is.size(); ++i) {
                    if (cip.is.get(i) != null) continue;
                    Errors.missingDependency(cip.con, i);
                }
            }
            this.constructor = cip.con;
            this.injectables = AbstractHttpContextInjectable.transform(cip.is);
        }
    }

    public Class getResourceClass() {
        return this.c;
    }

    public Object construct(HttpContext hc) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object o = this._construct(hc);
        this.rci.inject(hc, o);
        for (Method postConstruct : this.postConstructs) {
            postConstruct.invoke(o, new Object[0]);
        }
        return o;
    }

    private Object _construct(HttpContext hc) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.injectables == null) {
            return this.constructor != null ? this.constructor.newInstance(new Object[0]) : this.c.newInstance();
        }
        Object[] params = new Object[this.injectables.size()];
        int i = 0;
        for (AbstractHttpContextInjectable injectable : this.injectables) {
            params[i++] = injectable != null ? injectable.getValue(hc) : null;
        }
        return this.constructor.newInstance(params);
    }

    private <T> ConstructorInjectablePair getConstructor(ServerInjectableProviderContext sipc, ComponentScope scope, AbstractResource ar) {
        if (ar.getConstructors().isEmpty()) {
            return null;
        }
        TreeSet<ConstructorInjectablePair> cs = new TreeSet<ConstructorInjectablePair>(new ConstructorComparator());
        for (AbstractResourceConstructor arc : ar.getConstructors()) {
            List<Injectable> is = sipc.getInjectable((AccessibleObject)arc.getCtor(), arc.getParameters(), scope);
            cs.add(new ConstructorInjectablePair(arc.getCtor(), is));
        }
        return (ConstructorInjectablePair)cs.first();
    }

    private static class ConstructorComparator<T>
    implements Comparator<ConstructorInjectablePair> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(ConstructorInjectablePair o1, ConstructorInjectablePair o2) {
            int p = Collections.frequency(o1.is, null) - Collections.frequency(o2.is, null);
            if (p != 0) {
                return p;
            }
            return o2.con.getParameterTypes().length - o1.con.getParameterTypes().length;
        }
    }

    private static class ConstructorInjectablePair {
        private final Constructor con;
        private final List<Injectable> is;

        private ConstructorInjectablePair(Constructor con, List<Injectable> is) {
            this.con = con;
            this.is = is;
        }
    }
}

