/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.bundles.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.bundles.generated.BundleType;
import org.ow2.jonas.report.extensions.bundles.generated.Bundles;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class BundlesReportExtension
implements IReportExtension,
FrameworkListener,
BundleListener,
Pojo {
    private InstanceManager __IM;
    public static final Log logger = LogFactory.getLog(BundlesReportExtension.class);
    public static final String EOL = "\n";
    public static final String XSD_PATH = "xsd/bundles-report.xsd";
    private boolean __Fbundles;
    private List<BundleType> bundles;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;
    private boolean __MframeworkEvent$org_osgi_framework_FrameworkEvent;
    private boolean __MbundleChanged$org_osgi_framework_BundleEvent;
    private boolean __MgetBundle$long;
    private boolean __MgetStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean;

    List __getbundles() {
        if (!this.__Fbundles) {
            return this.bundles;
        }
        return (List)this.__IM.onGet((Object)this, "bundles");
    }

    void __setbundles(List list) {
        if (!this.__Fbundles) {
            this.bundles = list;
            return;
        }
        this.__IM.onSet((Object)this, "bundles", (Object)list);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    public BundlesReportExtension(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private BundlesReportExtension(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setbundles(new ArrayList());
        this.__setbundleContext(bundleContext);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        this.__getbundleContext().addBundleListener((BundleListener)this);
        this.__getbundleContext().addFrameworkListener((FrameworkListener)this);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__getbundleContext().removeBundleListener((BundleListener)this);
        this.__getbundleContext().removeFrameworkListener((FrameworkListener)this);
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        Bundles bundles = new Bundles();
        List<BundleType> bundleTypeList = bundles.getBundle();
        bundleTypeList.addAll(this.__getbundles());
        return bundles;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/bundles-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return Bundles.class;
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        if (!this.__MframeworkEvent$org_osgi_framework_FrameworkEvent) {
            this.__M_frameworkEvent(frameworkEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "frameworkEvent$org_osgi_framework_FrameworkEvent", new Object[]{frameworkEvent});
            this.__M_frameworkEvent(frameworkEvent);
            this.__IM.onExit((Object)this, "frameworkEvent$org_osgi_framework_FrameworkEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "frameworkEvent$org_osgi_framework_FrameworkEvent", throwable);
            throw throwable;
        }
    }

    private void __M_frameworkEvent(FrameworkEvent frameworkEvent) {
        Throwable throwable = frameworkEvent.getThrowable();
        if (throwable != null) {
            StringBuilder stackTrace = new StringBuilder();
            this.getStackTrace(stackTrace, throwable, true);
            BundleType bundleType = this.getBundle(frameworkEvent.getBundle().getBundleId());
            if (bundleType != null) {
                bundleType.getError().add(stackTrace.toString());
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (!this.__MbundleChanged$org_osgi_framework_BundleEvent) {
            this.__M_bundleChanged(bundleEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bundleChanged$org_osgi_framework_BundleEvent", new Object[]{bundleEvent});
            this.__M_bundleChanged(bundleEvent);
            this.__IM.onExit((Object)this, "bundleChanged$org_osgi_framework_BundleEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bundleChanged$org_osgi_framework_BundleEvent", throwable);
            throw throwable;
        }
    }

    private void __M_bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle;
        if (bundleEvent != null && (bundle = bundleEvent.getBundle()) != null) {
            long bundleId = bundle.getBundleId();
            BundleType bundleType = this.getBundle(bundleId);
            if (bundleType == null) {
                bundleType = new BundleType();
                bundleType.setId(bundleId);
                bundleType.setSymbolicName(bundle.getSymbolicName());
                bundleType.setVersion(bundle.getVersion().toString());
                bundleType.setLocation(bundle.getLocation());
                this.__getbundles().add(bundleType);
            }
            int state = bundle.getState();
            switch (state) {
                case 1: {
                    bundleType.setState("Uninstalled");
                    break;
                }
                case 2: {
                    bundleType.setState("Installed");
                    break;
                }
                case 4: {
                    bundleType.setState("Resolved");
                    break;
                }
                case 8: {
                    bundleType.setState("Starting");
                    break;
                }
                case 16: {
                    bundleType.setState("Stopping");
                    break;
                }
                case 32: {
                    bundleType.setState("Active");
                }
            }
        }
    }

    private BundleType getBundle(long id) {
        BundleType bundleType;
        if (!this.__MgetBundle$long) {
            return this.__M_getBundle(id);
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(id);
            this.__IM.onEntry((Object)this, "getBundle$long", objectArray);
            bundleType = this.__M_getBundle(id);
            this.__IM.onExit((Object)this, "getBundle$long", (Object)bundleType);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBundle$long", throwable);
            throw throwable;
        }
        return bundleType;
    }

    private BundleType __M_getBundle(long id) {
        for (BundleType bundle : this.__getbundles()) {
            if (bundle.getId() != id) continue;
            return bundle;
        }
        return null;
    }

    private void getStackTrace(StringBuilder stringBuilder, Throwable throwable, boolean isRootThrowable) {
        if (!this.__MgetStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean) {
            this.__M_getStackTrace(stringBuilder, throwable, isRootThrowable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean", new Object[]{stringBuilder, throwable, new Boolean(isRootThrowable)});
            this.__M_getStackTrace(stringBuilder, throwable, isRootThrowable);
            this.__IM.onExit((Object)this, "getStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean", null);
        }
        catch (Throwable throwable2) {
            this.__IM.onError((Object)this, "getStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean", throwable2);
            throw throwable2;
        }
    }

    private void __M_getStackTrace(StringBuilder stringBuilder, Throwable throwable, boolean isRootThrowable) {
        if (throwable != null) {
            if (isRootThrowable) {
                stringBuilder.append(throwable.getClass().getName());
            } else {
                stringBuilder.append("Caused by : " + throwable.getClass().getName());
            }
            String message = throwable.getMessage();
            if (message != null) {
                stringBuilder.append(" : " + throwable.getMessage());
            }
            stringBuilder.append(EOL);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuilder.append("         at " + stackTraceElement + EOL);
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                this.getStackTrace(stringBuilder, throwable.getCause(), false);
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("bundles")) {
                this.__Fbundles = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
            if (set.contains("frameworkEvent$org_osgi_framework_FrameworkEvent")) {
                this.__MframeworkEvent$org_osgi_framework_FrameworkEvent = true;
            }
            if (set.contains("bundleChanged$org_osgi_framework_BundleEvent")) {
                this.__MbundleChanged$org_osgi_framework_BundleEvent = true;
            }
            if (set.contains("getBundle$long")) {
                this.__MgetBundle$long = true;
            }
            if (set.contains("getStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean")) {
                this.__MgetStackTrace$java_lang_StringBuilder$java_lang_Throwable$boolean = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

