/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.enc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.util.ee.metadata.common.api.enc.IENCBinding;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.enc.IInjectionTargetEnc;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationManagedBean;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationSqlDataSourceDefinition;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ENCBindingHolder
implements IENCBindingHolder {
    private Map<String, List<IInjectionTargetEnc>> fieldInjections = null;
    private Map<String, List<IInjectionTargetEnc>> methodInjections = null;
    private List<IENCBinding<IJavaxPersistenceContext>> persistenceContextBindings = new ArrayList<IENCBinding<IJavaxPersistenceContext>>();
    private List<IENCBinding<IJavaxPersistenceUnit>> persistenceUnitBindings = new ArrayList<IENCBinding<IJavaxPersistenceUnit>>();
    private Map<String, IENCBinding<IJAnnotationResource>> resourceBindings = new HashMap<String, IENCBinding<IJAnnotationResource>>();
    private List<IENCBinding<IJEjbEJB>> ejbBindings = new ArrayList<IENCBinding<IJEjbEJB>>();
    private List<IENCBinding<IJaxwsWebServiceRef>> wsBindings = new ArrayList<IENCBinding<IJaxwsWebServiceRef>>();
    private List<IENCBinding<IJAnnotationSqlDataSourceDefinition>> dataSourceBindings = null;
    private List<IENCBinding<IJAnnotationManagedBean>> managedBeanBindings = null;

    public ENCBindingHolder() {
        this.fieldInjections = new HashMap<String, List<IInjectionTargetEnc>>();
        this.methodInjections = new HashMap<String, List<IInjectionTargetEnc>>();
        this.dataSourceBindings = new ArrayList<IENCBinding<IJAnnotationSqlDataSourceDefinition>>();
        this.managedBeanBindings = new ArrayList<IENCBinding<IJAnnotationManagedBean>>();
    }

    public void addPersistenceContextBinding(IENCBinding<IJavaxPersistenceContext> binding) {
        this.persistenceContextBindings.add(binding);
    }

    @Override
    public List<IENCBinding<IJavaxPersistenceContext>> getPersistenceContextBindings() {
        return this.persistenceContextBindings;
    }

    public void addPersistenceUnitBinding(IENCBinding<IJavaxPersistenceUnit> binding) {
        this.persistenceUnitBindings.add(binding);
    }

    @Override
    public List<IENCBinding<IJavaxPersistenceUnit>> getPersistenceUnitBindings() {
        return this.persistenceUnitBindings;
    }

    public void addResourceBinding(IENCBinding<IJAnnotationResource> binding) {
        String bindingName = binding.getName();
        IENCBinding<IJAnnotationResource> existingResource = this.resourceBindings.get(bindingName);
        if (existingResource != null) {
            return;
        }
        this.resourceBindings.put(bindingName, binding);
    }

    @Override
    public List<IENCBinding<IJAnnotationResource>> getResourceBindings() {
        Collection<IENCBinding<IJAnnotationResource>> collection = this.resourceBindings.values();
        ArrayList<IENCBinding<IJAnnotationResource>> list = new ArrayList<IENCBinding<IJAnnotationResource>>();
        if (collection != null) {
            for (IENCBinding<IJAnnotationResource> item : collection) {
                list.add(item);
            }
        }
        return list;
    }

    public void addEJBBinding(IENCBinding<IJEjbEJB> binding) {
        this.ejbBindings.add(binding);
    }

    @Override
    public List<IENCBinding<IJEjbEJB>> getEJBBindings() {
        return this.ejbBindings;
    }

    public void addWebServicesBinding(IENCBinding<IJaxwsWebServiceRef> binding) {
        this.wsBindings.add(binding);
    }

    @Override
    public List<IENCBinding<IJaxwsWebServiceRef>> getWebServicesBindings() {
        return this.wsBindings;
    }

    public void addFieldInjectionTarget(String className, IInjectionTargetEnc injectionTargetEnc) {
        List<IInjectionTargetEnc> fieldInjectionTargets = this.fieldInjections.get(className);
        if (fieldInjectionTargets == null) {
            fieldInjectionTargets = new ArrayList<IInjectionTargetEnc>();
            this.fieldInjections.put(className, fieldInjectionTargets);
        }
        fieldInjectionTargets.add(injectionTargetEnc);
    }

    public void addMethodInjectionTarget(String className, IInjectionTargetEnc injectionTargetEnc) {
        List<IInjectionTargetEnc> methodInjectionTargets = this.methodInjections.get(className);
        if (methodInjectionTargets == null) {
            methodInjectionTargets = new ArrayList<IInjectionTargetEnc>();
            this.methodInjections.put(className, methodInjectionTargets);
        }
        methodInjectionTargets.add(injectionTargetEnc);
    }

    @Override
    public List<IInjectionTargetEnc> getFieldInjectionTargets(String className) {
        return this.fieldInjections.get(className);
    }

    @Override
    public List<IInjectionTargetEnc> getMethodInjectionTargets(String className) {
        return this.methodInjections.get(className);
    }

    @Override
    public Map<String, Map<String, String>> getInjectionMap() {
        HashMap<String, Map<String, String>> injectionsMap = new HashMap<String, Map<String, String>>();
        this.completeInjectionMap(injectionsMap, this.fieldInjections.entrySet(), false);
        this.completeInjectionMap(injectionsMap, this.methodInjections.entrySet(), true);
        return injectionsMap;
    }

    public void addDataSourceBinding(IENCBinding<IJAnnotationSqlDataSourceDefinition> dataSourceDefinitionENCBinding) {
        this.dataSourceBindings.add(dataSourceDefinitionENCBinding);
    }

    @Override
    public List<IENCBinding<IJAnnotationSqlDataSourceDefinition>> getDataSourceBindings() {
        return this.dataSourceBindings;
    }

    protected void completeInjectionMap(Map<String, Map<String, String>> injectionsMap, Set<Map.Entry<String, List<IInjectionTargetEnc>>> injections, boolean isMethod) {
        for (Map.Entry<String, List<IInjectionTargetEnc>> injectionForClass : injections) {
            String classname = injectionForClass.getKey();
            Map<String, String> injectionForGivenClass = injectionsMap.get(classname);
            if (injectionForGivenClass == null) {
                injectionForGivenClass = new HashMap<String, String>();
                injectionsMap.put(classname, injectionForGivenClass);
            }
            for (IInjectionTargetEnc injectionTargetEnc : injectionForClass.getValue()) {
                if (isMethod) {
                    injectionForGivenClass.put(injectionTargetEnc.getName().substring(4), injectionTargetEnc.getEncName());
                    continue;
                }
                injectionForGivenClass.put(injectionTargetEnc.getName(), injectionTargetEnc.getEncName());
            }
        }
    }
}

