/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.felix.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.service.command.Function;
import org.apache.felix.shell.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.shelbie.commands.felix.internal.FelixCommandWrapper;
import org.ow2.shelbie.core.IConverterManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component
public class FelixCommandManager
implements Pojo {
    private InstanceManager __IM;
    private static final String LEGACY_SCOPE = "legacy";
    private static Log logger = LogFactory.getLog(FelixCommandManager.class);
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __FconverterManager;
    @Requires
    private IConverterManager converterManager;
    private boolean __FregistrationByCommandName;
    private Map<String, ServiceRegistration> registrationByCommandName;
    private boolean __MbindCommand$org_apache_felix_shell_Command;
    private boolean __MunbindCommand$org_apache_felix_shell_Command;

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    IConverterManager __getconverterManager() {
        if (!this.__FconverterManager) {
            return this.converterManager;
        }
        return (IConverterManager)this.__IM.onGet((Object)this, "converterManager");
    }

    void __setconverterManager(IConverterManager iConverterManager) {
        if (!this.__FconverterManager) {
            this.converterManager = iConverterManager;
            return;
        }
        this.__IM.onSet((Object)this, "converterManager", (Object)iConverterManager);
    }

    Map __getregistrationByCommandName() {
        if (!this.__FregistrationByCommandName) {
            return this.registrationByCommandName;
        }
        return (Map)this.__IM.onGet((Object)this, "registrationByCommandName");
    }

    void __setregistrationByCommandName(Map map) {
        if (!this.__FregistrationByCommandName) {
            this.registrationByCommandName = map;
            return;
        }
        this.__IM.onSet((Object)this, "registrationByCommandName", (Object)map);
    }

    public FelixCommandManager(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private FelixCommandManager(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setregistrationByCommandName(new HashMap());
        this.__setbundleContext(bundleContext);
    }

    void bindCommand(Command command) {
        if (!this.__MbindCommand$org_apache_felix_shell_Command) {
            this.__M_bindCommand(command);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindCommand$org_apache_felix_shell_Command", new Object[]{command});
            this.__M_bindCommand(command);
            this.__IM.onExit((Object)this, "bindCommand$org_apache_felix_shell_Command", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindCommand$org_apache_felix_shell_Command", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __M_bindCommand(Command command) {
        String commandName = command.getName();
        if (this.__getregistrationByCommandName().containsKey(commandName)) {
            logger.warn((Object)("Command already bound: " + commandName), new Object[0]);
            return;
        }
        FelixCommandWrapper wrapper = new FelixCommandWrapper(command, this.__getconverterManager());
        Properties properties = new Properties();
        properties.put("osgi.command.function", commandName);
        properties.put("osgi.command.scope", LEGACY_SCOPE);
        ServiceRegistration registration = this.__getbundleContext().registerService(Function.class.getName(), (Object)wrapper, (Dictionary)properties);
        this.__getregistrationByCommandName().put(commandName, registration);
    }

    void unbindCommand(Command command) {
        if (!this.__MunbindCommand$org_apache_felix_shell_Command) {
            this.__M_unbindCommand(command);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindCommand$org_apache_felix_shell_Command", new Object[]{command});
            this.__M_unbindCommand(command);
            this.__IM.onExit((Object)this, "unbindCommand$org_apache_felix_shell_Command", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindCommand$org_apache_felix_shell_Command", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindCommand(Command command) {
        ServiceRegistration registration = (ServiceRegistration)this.__getregistrationByCommandName().remove(command.getName());
        if (registration != null) {
            registration.unregister();
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("converterManager")) {
                this.__FconverterManager = true;
            }
            if (set.contains("registrationByCommandName")) {
                this.__FregistrationByCommandName = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("bindCommand$org_apache_felix_shell_Command")) {
                this.__MbindCommand$org_apache_felix_shell_Command = true;
            }
            if (set.contains("unbindCommand$org_apache_felix_shell_Command")) {
                this.__MunbindCommand$org_apache_felix_shell_Command = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

