/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.modeler.BaseModelMBean;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.jmbeans.J2EEServer;
import org.ow2.jonas.lib.loader.FilteringClassLoader;
import org.ow2.jonas.lib.management.javaee.J2EEServerState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class J2EEServerMBean
extends BaseModelMBean {
    public String getState() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        J2EEServerState state = ((J2EEServer)this.getManagedResource()).getState();
        return state.getName();
    }

    public String[] getResources() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        List<String> resourceList = ((J2EEServer)this.getManagedResource()).getResources();
        String[] result = new String[resourceList.size()];
        return resourceList.toArray(result);
    }

    public String[] getServices() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        List<String> services = ((J2EEServer)this.getManagedResource()).getServices();
        String[] result = new String[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            result[i] = services.get(i);
        }
        return result;
    }

    public String[] getDeployedObjects() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        List<String> deployedObjects = ((J2EEServer)this.getManagedResource()).getDeployedObjects();
        String[] result = new String[deployedObjects.size()];
        for (int i = 0; i < deployedObjects.size(); ++i) {
            result[i] = deployedObjects.get(i);
        }
        return result;
    }

    public String getServiceState(String service) throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        return ((J2EEServer)this.getManagedResource()).getServiceState(service);
    }

    public String getExportedPackagesFromPackage(String packageName) throws MBeanException, InstanceNotFoundException, RuntimeOperationsException, InvalidTargetObjectTypeException, TransformerException {
        return this.getExportedPackages(packageName, false);
    }

    public String getExportedPackagesFromClass(String className) throws MBeanException, InstanceNotFoundException, RuntimeOperationsException, InvalidTargetObjectTypeException, TransformerException {
        return this.getExportedPackages(className, true);
    }

    public String getExportedPackages(String name, boolean isClass) throws MBeanException, InstanceNotFoundException, RuntimeOperationsException, InvalidTargetObjectTypeException, TransformerException {
        ExportedPackage[] exportedPackages;
        J2EEServer j2eeServer = (J2EEServer)this.getManagedResource();
        PackageAdmin packageAdmin = j2eeServer.getPackageAdminService();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot build document builder", e);
        }
        Document document = builder.newDocument();
        Element root = document.createElement("exported-packages");
        document.appendChild(root);
        String packageName = null;
        Class<?> foundClass = null;
        String className = null;
        if (!isClass) {
            packageName = name;
        } else {
            className = name;
            JClassLoader systemClassLoader = null;
            try {
                systemClassLoader = LoaderManager.getInstance().getExternalLoader();
            }
            catch (Exception e) {
                throw new MBeanException(e, "Unable to get external classloader");
            }
            try {
                foundClass = systemClassLoader.loadClass(name);
                packageName = foundClass.getPackage().getName();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (packageName != null && (exportedPackages = packageAdmin.getExportedPackages(packageName)) != null) {
            for (ExportedPackage exportedPackage : exportedPackages) {
                Element exportedPackageElement = document.createElement("exported-package");
                root.appendChild(exportedPackageElement);
                exportedPackageElement.setAttribute("name", exportedPackage.getName());
                exportedPackageElement.setAttribute("version", exportedPackage.getVersion().toString());
                exportedPackageElement.setAttribute("removal-pending", Boolean.toString(exportedPackage.isRemovalPending()));
                boolean isDefaultBundle = false;
                Bundle exportingBundle = exportedPackage.getExportingBundle();
                if (exportingBundle != null) {
                    Element bundleElement = J2EEServerMBean.addBundleNode(document, "exporting-bundle", exportingBundle);
                    exportedPackageElement.appendChild(bundleElement);
                    if (className != null) {
                        Class bundleClass = null;
                        try {
                            bundleClass = exportingBundle.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                        if (foundClass.equals(bundleClass)) {
                            isDefaultBundle = true;
                        }
                    }
                }
                exportedPackageElement.setAttribute("isDefault", Boolean.toString(isDefaultBundle));
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                Element importingBundlesElement = document.createElement("importing-bundles");
                exportedPackageElement.appendChild(importingBundlesElement);
                for (Bundle importingBundle : importingBundles) {
                    importingBundlesElement.appendChild(J2EEServerMBean.addBundleNode(document, "importing-bundle", importingBundle));
                }
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(document), streamResult);
        return stringWriter.toString();
    }

    public String loadClass(String className) {
        Transformer transformer;
        JClassLoader systemClassLoader = null;
        try {
            systemClassLoader = LoaderManager.getInstance().getExternalLoader();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get LoaderManager", e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot build document builder", e);
        }
        Document document = builder.newDocument();
        Element classElement = document.createElement("class");
        document.appendChild(classElement);
        classElement.setAttribute("name", className);
        boolean classNotFound = false;
        String error = null;
        Class<?> clazz = null;
        try {
            clazz = systemClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            error = e.toString();
            classNotFound = true;
        }
        catch (Error e) {
            classNotFound = true;
            error = e.toString();
        }
        classElement.setAttribute("classNotFound", Boolean.toString(classNotFound));
        if (classNotFound) {
            Element errorElement = document.createElement("error");
            classElement.appendChild(errorElement);
            Text errorText = document.createTextNode(error);
            errorElement.appendChild(errorText);
        } else {
            String type = "Module";
            ClassLoader classClassLoader = clazz.getClassLoader();
            classElement.setAttribute("where", "System");
            if (classClassLoader != null) {
                Element classLoaderElement = document.createElement("class-loader");
                classElement.appendChild(classLoaderElement);
                classLoaderElement.setAttribute("name", classClassLoader.getClass().getName());
                Text classLoaderText = document.createTextNode(classClassLoader.toString());
                classLoaderElement.appendChild(classLoaderText);
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Unable to get a new transformer", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unable to transform the document", e);
        }
        return stringWriter.toString();
    }

    public String[] getClassLoaderFilters() throws MBeanException {
        JClassLoader systemClassLoader = null;
        try {
            systemClassLoader = LoaderManager.getInstance().getExternalLoader();
        }
        catch (Exception e) {
            throw new MBeanException(e, "Unable to get the external classloader");
        }
        ClassLoader parent = systemClassLoader.getParent();
        FilteringClassLoader filteringClassLoader = null;
        if (!(parent instanceof FilteringClassLoader)) {
            throw new IllegalStateException("Unable to get the filtering classloader as parent classloader. Found instead : '" + parent + "'.");
        }
        filteringClassLoader = (FilteringClassLoader)parent;
        List filters = filteringClassLoader.getFilters();
        return filters.toArray(new String[filters.size()]);
    }

    public URL[] getResources(String resourceName) throws MBeanException {
        JClassLoader systemClassLoader = null;
        try {
            systemClassLoader = LoaderManager.getInstance().getExternalLoader();
        }
        catch (Exception e) {
            throw new MBeanException(e, "Unable to get the external classloader");
        }
        Enumeration<URL> urls = null;
        try {
            urls = systemClassLoader.getResources(resourceName);
        }
        catch (IOException e) {
            throw new MBeanException(e, "Unable to get the resource '" + resourceName + "'.");
        }
        ArrayList<URL> urlsList = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            urlsList.add(urls.nextElement());
        }
        return urlsList.toArray(new URL[urlsList.size()]);
    }

    protected static Element addBundleNode(Document document, String elementName, Bundle bundle) {
        Element rootElement = J2EEServerMBean.addNode(document, elementName, null);
        rootElement.appendChild(J2EEServerMBean.addNode(document, "bundle-id", Long.toString(bundle.getBundleId())));
        rootElement.appendChild(J2EEServerMBean.addNode(document, "symbolic-name", bundle.getSymbolicName()));
        rootElement.appendChild(J2EEServerMBean.addNode(document, "location", bundle.getLocation()));
        rootElement.appendChild(J2EEServerMBean.addNode(document, "version", bundle.getVersion().toString()));
        rootElement.appendChild(J2EEServerMBean.addNode(document, "last-modified", Long.toString(bundle.getLastModified())));
        rootElement.appendChild(J2EEServerMBean.addNode(document, "state", Integer.toString(bundle.getState())));
        return rootElement;
    }

    protected static Element addNode(Document document, String elementName, String value, Map<String, String> attributes) {
        Element nodeElement = document.createElement(elementName);
        if (attributes != null) {
            Set<Map.Entry<String, String>> entries = attributes.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                nodeElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (value != null) {
            Text text = document.createTextNode(value);
            nodeElement.appendChild(text);
        }
        return nodeElement;
    }

    protected static Element addNode(Document document, String elementName, String value) {
        return J2EEServerMBean.addNode(document, elementName, value, null);
    }
}

