/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.xml.parsing;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceGroup;
import org.ow2.util.ee.metadata.common.api.xml.struct.IServiceRef;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.AbsDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.DataSource;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBLocalRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.xml.struct.Handler;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChain;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChains;
import org.ow2.util.ee.metadata.common.impl.xml.struct.InjectionTarget;
import org.ow2.util.ee.metadata.common.impl.xml.struct.LifeCycleCallback;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MessageDestinationRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PersistenceContextRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PersistenceUnitRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PortComponentRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceEnvRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.SecurityRoleRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CommonDeploymentDescLoader
extends AbsDeploymentDescLoader {
    private static final Log logger = LogFactory.getLog(CommonDeploymentDescLoader.class);

    protected CommonDeploymentDescLoader(URL url) {
        super(url);
    }

    protected void analyzeEnvironment(Element envElement, IEnvironment env) {
        this.analyzeLifeCycle(envElement, env, "post-construct");
        this.analyzeLifeCycle(envElement, env, "pre-destroy");
        this.analyzeEnvEnvtry(envElement, env);
        this.analyzeEJBRef(envElement, env);
        this.analyzeEJBLocalRef(envElement, env);
        this.analyzeResourceRef(envElement, env);
        this.analyzeResourceEnvRef(envElement, env);
        this.analyzeMessageDestinationRef(envElement, env);
        this.analyzePersistenceContextRef(envElement, env);
        this.analyzePersistenceUnitRef(envElement, env);
        this.analyzeServiceRef(envElement, env);
        this.analyzeSecurityRoleRef(envElement, env);
        this.analyzeDataSource(envElement, env);
    }

    private void analyzeCommonEJBRef(Element refElement, AbsEJBRef ref) {
        String ejbRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-name");
        ref.setEjbRefName(ejbRefName);
        String ejbRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-type");
        ref.setEjbRefType(ejbRefType);
        String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"mapped-name");
        ref.setMappedName(mappedName);
        String lookupName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"lookup-name");
        ref.setLookupName(lookupName);
        String ejbLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-link");
        ref.setEjbLink(ejbLink);
        this.analyzeInjectionTarget(refElement, ref);
    }

    private void analyzeInjectionTarget(Element refElement, IResourceGroup resourceGroup) {
        NodeList injectionTargetList = refElement.getElementsByTagNameNS(this.getXMLNS(), "injection-target");
        for (int j = 0; j < injectionTargetList.getLength(); ++j) {
            Element injectionTargetElement = (Element)injectionTargetList.item(j);
            InjectionTarget injectionTarget = new InjectionTarget();
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-class");
            injectionTarget.setClassname(className);
            String targetName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-name");
            injectionTarget.setTargetName(targetName);
            resourceGroup.addInjectionTarget(injectionTarget);
        }
    }

    private void analyzeEJBRef(Element envElement, IEnvironment env) {
        NodeList ejbRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-ref");
        for (int i = 0; i < ejbRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbRefList.item(i);
            EJBRef ejbRef = new EJBRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbRef);
            String remote = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"remote");
            ejbRef.setRemote(remote);
            String home = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"home");
            ejbRef.setHome(home);
            env.addEJBRef(ejbRef);
        }
    }

    private void analyzeResourceRef(Element envElement, IEnvironment env) {
        NodeList resourceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-ref");
        for (int i = 0; i < resourceRefList.getLength(); ++i) {
            Element resourceRefElement = (Element)resourceRefList.item(i);
            ResourceRef resourceRef = new ResourceRef();
            String resRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-ref-name");
            resourceRef.setResRefName(resRefName);
            String resRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-type");
            resourceRef.setResRefType(resRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"mapped-name");
            resourceRef.setMappedName(mappedName);
            String lookupName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"lookup-name");
            resourceRef.setLookupName(lookupName);
            this.analyzeInjectionTarget(resourceRefElement, resourceRef);
            env.addResourceRef(resourceRef);
        }
    }

    private void analyzeSecurityRoleRef(Element envElement, IEnvironment env) {
        NodeList securityRoleRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "security-role-ref");
        for (int i = 0; i < securityRoleRefList.getLength(); ++i) {
            Element securityRoleRefElement = (Element)securityRoleRefList.item(i);
            SecurityRoleRef securityRoleRef = new SecurityRoleRef();
            String roleName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)securityRoleRefElement, (String)"role-name");
            securityRoleRef.setRoleName(roleName);
            String roleLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)securityRoleRefElement, (String)"role-link");
            securityRoleRef.setRoleLink(roleLink);
            env.addSecurityRoleRef(securityRoleRef);
        }
    }

    private void analyzeMessageDestinationRef(Element envElement, IEnvironment env) {
        NodeList messageDestinationRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination-ref");
        for (int i = 0; i < messageDestinationRefList.getLength(); ++i) {
            Element messageDestinationRefElement = (Element)messageDestinationRefList.item(i);
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-ref-name");
            messageDestinationRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-type");
            messageDestinationRef.setType(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-usage");
            messageDestinationRef.setUsage(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-link");
            messageDestinationRef.setLink(link);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"mapped-name");
            messageDestinationRef.setMappedName(mappedName);
            String lookupName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"lookup-name");
            messageDestinationRef.setLookupName(lookupName);
            this.analyzeInjectionTarget(messageDestinationRefElement, messageDestinationRef);
            env.addMessageDestinationRef(messageDestinationRef);
        }
    }

    private void analyzePersistenceUnitRef(Element envElement, IEnvironment env) {
        logger.debug((Object)"Analyze environment, looking for persistence-unit-ref", new Object[0]);
        NodeList persistenceUnitRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "persistence-unit-ref");
        for (int i = 0; i < persistenceUnitRefList.getLength(); ++i) {
            Element persistenceUnitRefElement = (Element)persistenceUnitRefList.item(i);
            PersistenceUnitRef persistenceUnitRef = new PersistenceUnitRef();
            String unitRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceUnitRefElement, (String)"persistence-unit-ref-name");
            if (unitRefName != null) {
                persistenceUnitRef.setPersistenceUnitRefName(unitRefName);
            }
            logger.debug((Object)("Analyze environment, found persistence-unit-ref-name " + unitRefName), new Object[0]);
            String unitName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceUnitRefElement, (String)"persistence-unit-name");
            if (unitName != null) {
                persistenceUnitRef.setPersistenceUnitName(unitName);
            }
            env.addPersistenceUnitRef(persistenceUnitRef);
        }
    }

    private void analyzePersistenceContextRef(Element envElement, IEnvironment env) {
        logger.debug((Object)"Analyze environment, looking for persistence-context-ref", new Object[0]);
        NodeList persistenceContextRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "persistence-context-ref");
        for (int i = 0; i < persistenceContextRefList.getLength(); ++i) {
            String contextType;
            Element persistenceContextRefElement = (Element)persistenceContextRefList.item(i);
            PersistenceContextRef persistenceContextRef = new PersistenceContextRef();
            String contextRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceContextRefElement, (String)"persistence-context-ref-name");
            if (contextRefName != null) {
                persistenceContextRef.setPersistenceContextRefName(contextRefName);
            }
            logger.debug((Object)("Analyze environment, found persistence-context-ref-name " + contextRefName), new Object[0]);
            String unitName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceContextRefElement, (String)"persistence-unit-name");
            if (unitName != null) {
                persistenceContextRef.setPersistenceUnitName(unitName);
            }
            if ((contextType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)persistenceContextRefElement, (String)"persistence-context-type")) != null) {
                persistenceContextRef.setPersistenceContextType(contextType);
            }
            env.addPersistenceContextRef(persistenceContextRef);
        }
    }

    private void analyzeServiceRef(Element envElement, IEnvironment env) {
        NodeList serviceRefList = envElement.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "service-ref");
        for (int i = 0; i < serviceRefList.getLength(); ++i) {
            NodeList serviceQNameList;
            Element serviceRefElement = (Element)serviceRefList.item(i);
            ServiceRef serviceRef = new ServiceRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-ref-name");
            serviceRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-interface");
            serviceRef.setServiceInterface(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-ref-type");
            serviceRef.setServiceRefType(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"wsdl-file");
            if (link != null) {
                URI location = null;
                try {
                    location = new URI(link);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Element 'wsdl-file' is not a valid URI", e);
                }
                serviceRef.setWsdlFile(location);
            }
            if ((serviceQNameList = envElement.getElementsByTagNameNS(this.getXMLNS(), "service-qname")).getLength() == 1) {
                QName serviceQName = XMLUtils.getValueAsQName((Element)((Element)serviceQNameList.item(0)));
                serviceRef.setServiceQName(serviceQName);
            }
            this.analyzePortComponentRef(serviceRefElement, serviceRef);
            this.analyzeHandlerChains(serviceRefElement, serviceRef);
            this.analyzeInjectionTarget(serviceRefElement, serviceRef);
            env.addServiceRef(serviceRef);
        }
    }

    private void analyzeHandlerChains(Element serviceRefElement, IServiceRef serviceRef) {
        NodeList handlerChainsList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "handler-chains");
        if (handlerChainsList.getLength() == 1) {
            Element handlerChainsElement = (Element)handlerChainsList.item(0);
            HandlerChains handlerChains = new HandlerChains();
            serviceRef.setHandlerChains(handlerChains);
            this.analyzeHandlerChain(handlerChainsElement, handlerChains);
        }
    }

    protected void analyzeHandlerChain(Element handlerChainsElement, HandlerChains handlerChains) {
        NodeList handlerChainList = handlerChainsElement.getElementsByTagNameNS(this.getXMLNS(), "handler-chain");
        for (int i = 0; i < handlerChainList.getLength(); ++i) {
            Element handlerChainElement = (Element)handlerChainList.item(i);
            HandlerChain handlerChain = new HandlerChain();
            handlerChains.addHandlerChain(handlerChain);
            QName servicePattern = XMLUtils.getChildValueAsQName((Element)handlerChainElement, (String)"service-name-pattern");
            handlerChain.setServiceNamePattern(servicePattern);
            QName portPattern = XMLUtils.getChildValueAsQName((Element)handlerChainElement, (String)"port-name-pattern");
            handlerChain.setPortNamePattern(portPattern);
            this.analyzeProtocolBindings(handlerChainElement, handlerChain);
            this.analyzeHandlers(handlerChainElement, handlerChain);
        }
    }

    private void analyzeHandlers(Element handlerChainElement, HandlerChain handlerChain) {
        NodeList handlerList = handlerChainElement.getElementsByTagNameNS(this.getXMLNS(), "handler");
        for (int i = 0; i < handlerList.getLength(); ++i) {
            Element handlerElement = (Element)handlerList.item(i);
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)handlerElement, (String)"handler-name");
            String classname = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)handlerElement, (String)"handler-class");
            Handler handler = new Handler(name, classname);
            handlerChain.addHandler(handler);
            QName soapHeader = XMLUtils.getChildValueAsQName((Element)handlerElement, (String)"soap-header");
            handler.setSoapHeader(soapHeader);
            String soapRole = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)handlerElement, (String)"soap-role");
            handler.setSoapRole(soapRole);
            this.analyzeInitParam(handlerElement, handler);
        }
    }

    private void analyzeInitParam(Element handlerElement, Handler handler) {
        NodeList initParamList = handlerElement.getElementsByTagNameNS(this.getXMLNS(), "init-param");
        for (int i = 0; i < initParamList.getLength(); ++i) {
            Element initParamElement = (Element)initParamList.item(i);
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)handlerElement, (String)"param-name");
            String value = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)handlerElement, (String)"param-value");
            handler.addInitParam(name, value);
        }
    }

    private void analyzeProtocolBindings(Element handlerChainElement, HandlerChain handlerChain) {
        String bindingsValue = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)handlerChainElement, (String)"protocol-bindings");
        if (bindingsValue != null) {
            String[] bindings;
            for (String binding : bindings = bindingsValue.split(" ")) {
                handlerChain.addProtocolBinding(binding);
            }
        }
    }

    private void analyzePortComponentRef(Element serviceRefElement, IServiceRef serviceRef) {
        NodeList portComponentRefList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "port-component-ref");
        for (int i = 0; i < portComponentRefList.getLength(); ++i) {
            Element portComponentRefElement = (Element)portComponentRefList.item(i);
            PortComponentRef portComponentRef = new PortComponentRef();
            String sei = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"service-endpoint-interface");
            portComponentRef.setServiceEndpointInterface(sei);
            String enableMTOM = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"enable-mtom");
            if (enableMTOM != null) {
                portComponentRef.setEnableMTOM(Boolean.parseBoolean(enableMTOM));
            }
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"port-component-link");
            portComponentRef.setPortComponentLink(link);
            serviceRef.addPortComponentRef(portComponentRef);
        }
    }

    private void analyzeResourceEnvRef(Element envElement, IEnvironment env) {
        NodeList resourceEnvRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-env-ref");
        for (int i = 0; i < resourceEnvRefList.getLength(); ++i) {
            Element resourceEnvRefElement = (Element)resourceEnvRefList.item(i);
            ResourceEnvRef resourceEnvRef = new ResourceEnvRef();
            String resourceEnvRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-name");
            resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
            String resourceEnvRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-type");
            resourceEnvRef.setResourceEnvRefType(resourceEnvRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"mapped-name");
            resourceEnvRef.setMappedName(mappedName);
            String lookupName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"lookup-name");
            resourceEnvRef.setLookupName(lookupName);
            this.analyzeInjectionTarget(resourceEnvRefElement, resourceEnvRef);
            env.addResourceEnvRef(resourceEnvRef);
        }
    }

    private void analyzeEJBLocalRef(Element envElement, IEnvironment env) {
        NodeList ejbLocalRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-local-ref");
        for (int i = 0; i < ejbLocalRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbLocalRefList.item(i);
            EJBLocalRef ejbLocalRef = new EJBLocalRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbLocalRef);
            String local = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local");
            ejbLocalRef.setLocal(local);
            String localHome = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local-home");
            ejbLocalRef.setLocalHome(localHome);
            env.addEJBLocalRef(ejbLocalRef);
        }
    }

    private void analyzeEnvEnvtry(Element envElement, IEnvironment bean) {
        NodeList envEntryList = envElement.getElementsByTagNameNS(this.getXMLNS(), "env-entry");
        for (int i = 0; i < envEntryList.getLength(); ++i) {
            Element envEntryElement = (Element)envEntryList.item(i);
            EnvEntry envEntry = new EnvEntry();
            bean.addEnvEntry(envEntry);
            String envEntryName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-name");
            envEntry.setEnvEntryName(envEntryName);
            String envEntryType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-type");
            envEntry.setEnvEntryType(envEntryType);
            String envEntryValue = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-value", (boolean)false);
            envEntry.setEnvEntryValue(envEntryValue);
            String envEntryLookupName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"lookup-name", (boolean)false);
            envEntry.setLookupName(envEntryLookupName);
            this.analyzeInjectionTarget(envEntryElement, envEntry);
        }
    }

    protected void analyzeLifeCycle(Element envElement, IEnvironment env, String lifecycleName) {
        NodeList lifecycleList = envElement.getElementsByTagNameNS(this.getXMLNS(), lifecycleName);
        for (int i = 0; i < lifecycleList.getLength(); ++i) {
            Element lifeCycleElement = (Element)lifecycleList.item(i);
            LifeCycleCallback lifecycleCallback = new LifeCycleCallback();
            if ("post-construct".equals(lifecycleName)) {
                env.addPostConstructCallback(lifecycleCallback);
            } else if ("pre-destroy".equals(lifecycleName)) {
                env.addPreDestroyCallback(lifecycleCallback);
            } else if ("pre-passivate".equals(lifecycleName)) {
                env.addPrePassivateCallback(lifecycleCallback);
            } else if ("post-activate".equals(lifecycleName)) {
                env.addPostActivateCallback(lifecycleCallback);
            } else {
                throw new IllegalArgumentException("Unknown lifecycle named '" + lifecycleName + "'.");
            }
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-class");
            lifecycleCallback.setLifecycleCallbackClass(className);
            String method = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-method");
            lifecycleCallback.setMethodName(method);
        }
    }

    private void analyzeDataSource(Element envElement, IEnvironment env) {
        NodeList dataSourceList = envElement.getElementsByTagNameNS(this.getXMLNS(), "data-source");
        for (int i = 0; i < dataSourceList.getLength(); ++i) {
            String dataSourceMaxStatements;
            String dataSourceMaxIdleTime;
            String dataSourceMinPoolSize;
            String dataSourceMaxPoolSize;
            String dataSourceInitialPoolSize;
            String dataSourceIsolationLevel;
            String dataSourceTransactional;
            String dataSourcePassword;
            String dataSourceUser;
            String dataSourceUrl;
            String dataSourceDatabaseName;
            String dataSourcePortNumber;
            Element dataSourceElement = (Element)dataSourceList.item(i);
            DataSource dataSource = new DataSource();
            String dataSourceName = null;
            NodeList dataSourceNamesList = dataSourceElement.getElementsByTagNameNS(this.getXMLNS(), "name");
            for (int n = 0; n < dataSourceNamesList.getLength(); ++n) {
                Node node;
                Element dataSourceNameElement = (Element)dataSourceNamesList.item(n);
                if (dataSourceNameElement.getParentNode() != dataSourceElement || (node = dataSourceNameElement.getFirstChild()) == null || (dataSourceName = node.getNodeValue()) == null) continue;
                dataSourceName = dataSourceName.trim();
                break;
            }
            if (dataSourceName == null) {
                logger.warn((Object)"Malformed environment: data-source name element missing", new Object[0]);
                continue;
            }
            if (!(dataSourceName.startsWith("java:app/") || dataSourceName.startsWith("java:comp/") || dataSourceName.startsWith("java:global/") || dataSourceName.startsWith("java:module/"))) {
                dataSourceName = "java:comp/env/" + dataSourceName;
            }
            dataSource.setName(dataSourceName);
            String dataSourceDescription = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"description");
            if (dataSourceDescription != null) {
                dataSource.setDescription(dataSourceDescription);
            }
            String dataSourceClassName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"class-name");
            dataSource.setClassName(dataSourceClassName);
            String dataSourceServerName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"server-name");
            if (dataSourceServerName != null) {
                dataSource.setServerName(dataSourceServerName);
            }
            if ((dataSourcePortNumber = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"port-number")) != null) {
                try {
                    dataSource.setPortNumber(Integer.parseInt(dataSourcePortNumber));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"port-number element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            if ((dataSourceDatabaseName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"database-name")) != null) {
                dataSource.setDatabaseName(dataSourceDatabaseName);
            }
            if ((dataSourceUrl = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"url")) != null) {
                dataSource.setUrl(dataSourceUrl);
            }
            if ((dataSourceUser = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"user")) != null) {
                dataSource.setUser(dataSourceUser);
            }
            if ((dataSourcePassword = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"password")) != null) {
                dataSource.setPassword(dataSourcePassword);
            }
            NodeList propertiesList = dataSourceElement.getElementsByTagNameNS(this.getXMLNS(), "property");
            String[] dataSourceProperties = new String[propertiesList.getLength()];
            if (propertiesList.getLength() > 0) {
                for (int j = 0; j < propertiesList.getLength(); ++j) {
                    Element elemProperty = (Element)propertiesList.item(j);
                    String pName = XMLUtils.getStringValueElement((Element)elemProperty, (String)"name");
                    String pValue = XMLUtils.getStringValueElement((Element)elemProperty, (String)"value");
                    if (pName == null || pValue == null) continue;
                    dataSourceProperties[j] = pName + "=" + pValue;
                }
            }
            dataSource.setProperties(dataSourceProperties);
            String dataSourceLoginTimeout = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"login-timeout");
            if (dataSourceLoginTimeout != null) {
                try {
                    dataSource.setLoginTimeout(Integer.parseInt(dataSourceLoginTimeout));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"login-timeout element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            if ((dataSourceTransactional = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"transactional")) != null) {
                if (dataSourceTransactional.equalsIgnoreCase("true") || dataSourceTransactional.equalsIgnoreCase("1")) {
                    dataSource.setTransactional(true);
                } else if (dataSourceTransactional.equalsIgnoreCase("false") || dataSourceTransactional.equalsIgnoreCase("0")) {
                    dataSource.setTransactional(false);
                } else {
                    logger.warn((Object)"transactional element for data-source {0} is not a valid boolean. Using default value", new Object[]{dataSource.getName()});
                }
            }
            if ((dataSourceIsolationLevel = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"isolation-level")) != null) {
                if (dataSourceIsolationLevel.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    dataSource.setIsolationLevel(1);
                } else if (dataSourceIsolationLevel.equals("TRANSACTION_READ_COMMITTED")) {
                    dataSource.setIsolationLevel(2);
                } else if (dataSourceIsolationLevel.equals("TRANSACTION_REPEATABLE_READ")) {
                    dataSource.setIsolationLevel(4);
                } else if (dataSourceIsolationLevel.equals("TRANSACTION_SERIALIZABLE")) {
                    dataSource.setIsolationLevel(8);
                }
            }
            if ((dataSourceInitialPoolSize = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"initial-pool-size")) != null) {
                try {
                    dataSource.setInitialPoolSize(Integer.parseInt(dataSourceInitialPoolSize));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"initial-pool-size element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            if ((dataSourceMaxPoolSize = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"max-pool-size")) != null) {
                try {
                    dataSource.setMaxPoolSize(Integer.parseInt(dataSourceMaxPoolSize));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"max-pool-size element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            if ((dataSourceMinPoolSize = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"min-pool-size")) != null) {
                try {
                    dataSource.setMinPoolSize(Integer.parseInt(dataSourceMinPoolSize));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"min-pool-size element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            if ((dataSourceMaxIdleTime = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"max-idle-time")) != null) {
                try {
                    dataSource.setMaxIdleTime(Integer.parseInt(dataSourceMaxIdleTime));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"max-idle-time element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            if ((dataSourceMaxStatements = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)dataSourceElement, (String)"max-statements")) != null) {
                try {
                    dataSource.setMaxStatements(Integer.parseInt(dataSourceMaxStatements));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"max-statements element for data-source {0} is not a valid integer", new Object[]{dataSource.getName()});
                    logger.debug((Object)e, new Object[0]);
                }
            }
            env.addDataSource(dataSource);
        }
    }
}

