/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.ParseUtils;

public class MethodMetadata {
    public static final String EMPTY_CONSTRUCTOR_ID = "$init";
    public static final String BC_CONSTRUCTOR_ID = "$init$org_osgi_framework_BundleContext";
    public static final String CONSTRUCTOR_PREFIX = "$init";
    private String m_name;
    private String[] m_arguments = new String[0];
    private String m_return = "void";
    static /* synthetic */ Class class$org$apache$felix$ipojo$InstanceManager;

    MethodMetadata(Element metadata) {
        this.m_name = metadata.getAttribute("name");
        String arg = metadata.getAttribute("arguments");
        String result = metadata.getAttribute("return");
        if (arg != null) {
            this.m_arguments = ParseUtils.parseArrays(arg);
        }
        if (result != null) {
            this.m_return = result;
        }
    }

    public String getMethodName() {
        return this.m_name;
    }

    public String[] getMethodArguments() {
        return this.m_arguments;
    }

    public String getMethodReturn() {
        return this.m_return;
    }

    public String getMethodIdentifier() {
        StringBuffer identifier = new StringBuffer(this.m_name);
        for (int i = 0; i < this.m_arguments.length; ++i) {
            String arg = this.m_arguments[i];
            if (arg.endsWith("[]")) {
                String acc = "";
                while (arg.endsWith("[]")) {
                    arg = arg.substring(0, arg.length() - 2);
                    acc = acc + "__";
                }
                identifier.append("$" + arg.replace('.', '_') + acc);
                continue;
            }
            identifier.append("$" + arg.replace('.', '_'));
        }
        return identifier.toString();
    }

    public static String computeMethodId(Method method) {
        StringBuffer identifier = new StringBuffer(method.getName());
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            identifier.append('$');
            if (args[i].isArray()) {
                String acc = "__";
                if (args[i].getComponentType().isPrimitive()) {
                    identifier.append(FieldMetadata.getPrimitiveTypeByClass(args[i].getComponentType()));
                } else if (args[i].getComponentType().isArray()) {
                    Class<?> current = args[i].getComponentType();
                    while (current.isArray()) {
                        acc = acc + "__";
                        current = current.getComponentType();
                    }
                    acc = current.isPrimitive() ? FieldMetadata.getPrimitiveTypeByClass(current) + acc : current.getName().replace('.', '_') + acc;
                } else {
                    identifier.append(args[i].getComponentType().getName().replace('.', '_'));
                }
                identifier.append(acc);
                continue;
            }
            if (args[i].isPrimitive()) {
                identifier.append(FieldMetadata.getPrimitiveTypeByClass(args[i]));
                continue;
            }
            identifier.append(args[i].getName().replace('.', '_'));
        }
        return identifier.toString();
    }

    public static String computeMethodId(Constructor method) {
        StringBuffer identifier = new StringBuffer("$init");
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0 && (class$org$apache$felix$ipojo$InstanceManager == null ? MethodMetadata.class$("org.apache.felix.ipojo.InstanceManager") : class$org$apache$felix$ipojo$InstanceManager).equals(args[i])) continue;
            identifier.append('$');
            if (args[i].isArray()) {
                String acc = "__";
                if (args[i].getComponentType().isPrimitive()) {
                    identifier.append(FieldMetadata.getPrimitiveTypeByClass(args[i].getComponentType()));
                } else if (args[i].getComponentType().isArray()) {
                    Class<?> current = args[i].getComponentType();
                    while (current.isArray()) {
                        acc = acc + "__";
                        current = current.getComponentType();
                    }
                } else {
                    identifier.append(args[i].getComponentType().getName().replace('.', '_'));
                }
                identifier.append(acc);
                continue;
            }
            if (args[i].isPrimitive()) {
                identifier.append(FieldMetadata.getPrimitiveTypeByClass(args[i]));
                continue;
            }
            identifier.append(args[i].getName().replace('.', '_'));
        }
        return identifier.toString();
    }
}

