/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.versioning;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Response;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.web.tomcat7.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat7.versioning.VersionedPathBean;

public class FilteredOutputStream
extends OutputBuffer {
    private static List<String> SUPPORTED_BYTE_ARRAY_ENCODINGS = Arrays.asList("US-ASCII", "ISO-8859-1");
    private Response response;
    private int remainingChars = 0;

    public FilteredOutputStream(Response response) {
        this.response = response;
    }

    public FilteredOutputStream(Response response, int size) {
        super(size);
        this.response = response;
    }

    @Override
    public void writeByte(int b) throws IOException {
        String encoding = this.response.getCharacterEncoding();
        if (encoding == null || !SUPPORTED_BYTE_ARRAY_ENCODINGS.contains(encoding)) {
            super.writeByte(b);
        } else {
            super.checkConverter();
            this.doWrite(new String(new byte[]{(byte)b}, 0, 1, encoding), 0, 1);
        }
    }

    @Override
    public void write(byte[] buf, int off, int cnt) throws IOException {
        String encoding = this.response.getCharacterEncoding();
        if (encoding == null || !SUPPORTED_BYTE_ARRAY_ENCODINGS.contains(encoding)) {
            super.write(buf, off, cnt);
        } else {
            super.checkConverter();
            this.doWrite(new String(buf, off, cnt, encoding), 0, cnt);
        }
    }

    @Override
    public void write(String s, int off, int cnt) throws IOException {
        if (s == null) {
            super.write(s, off, cnt);
        } else {
            this.doWrite(s, off, cnt);
        }
    }

    @Override
    public void write(char[] buf, int off, int cnt) throws IOException {
        if (buf == null) {
            super.write(buf, off, cnt);
        } else {
            this.doWrite(new String(buf, off, cnt), 0, cnt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doWrite(String s, int off, int cnt) throws IOException {
        VersionedPathBean vpb = this.findVersionedPathBean(this.response.getContentType());
        if (vpb != null) {
            block12: {
                if (this.remainingChars != 0) {
                    String actual;
                    int compareLength;
                    int remainingCompare = vpb.getVersionedPath().length() - this.remainingChars;
                    String remainingVersionedPath = vpb.getVersionedPath().substring(remainingCompare);
                    String expected = remainingVersionedPath.substring(0, compareLength = Math.min(remainingVersionedPath.length(), cnt));
                    if (expected.equals(actual = s.substring(off, off + compareLength))) {
                        if (compareLength == remainingVersionedPath.length()) {
                            if (!"/".equals(vpb.getUserPath())) {
                                super.write(vpb.getUserPath());
                                this.remainingChars = 0;
                            }
                            off += compareLength;
                            cnt -= compareLength;
                            break block12;
                        } else {
                            this.remainingChars -= compareLength;
                            if (this.remainingChars > vpb.getVersionedPath().length()) {
                                throw new IllegalStateException("Remaining characters has exceeded versioned path length!");
                            }
                            return;
                        }
                    }
                    super.write(vpb.getVersionedPath().substring(0, remainingCompare));
                    this.remainingChars = 0;
                }
            }
            int originalOffset = off;
            int originalCount = cnt;
            int originalLength = originalOffset + originalCount;
            for (int i = originalOffset; i < originalLength; ++i) {
                String actual;
                if (vpb.getVersionedPath().charAt(0) != s.charAt(i)) continue;
                int compareLength = Math.min(vpb.getVersionedPath().length(), originalLength - i);
                String expected = vpb.getVersionedPath().substring(0, compareLength);
                if (!expected.equals(actual = s.substring(i, i + compareLength))) continue;
                String upToHere = s.substring(off, i);
                super.write(upToHere);
                if (compareLength == vpb.getVersionedPath().length()) {
                    if (!"/".equals(vpb.getUserPath())) {
                        super.write(vpb.getUserPath());
                    }
                    off = i += compareLength;
                    cnt = originalLength - off;
                    continue;
                }
                this.remainingChars = vpb.getVersionedPath().length() - compareLength;
                if (this.remainingChars > vpb.getVersionedPath().length()) {
                    throw new IllegalStateException("Remaining characters has exceeded versioned path length!");
                }
                return;
            }
        }
        if (s.length() < off + cnt) {
            throw new IllegalStateException(s);
        }
        super.write(s, off, cnt);
    }

    private VersionedPathBean findVersionedPathBean(String contentType) {
        if (contentType != null && ContextFinder.getParent() != null) {
            String[] filteredContentTypes;
            VersioningService versioning = ContextFinder.getParent().getVersioningService();
            VersionedPathBean vpb = this.response.getVersionedPathBean();
            if (vpb != null && vpb.getUserPath() != null && vpb.getVersionedPath() != null && versioning != null && versioning.isVersioningEnabled() && (filteredContentTypes = versioning.getFilteredContentTypesArray()) != null && filteredContentTypes.length > 0) {
                for (String filteredContentType : filteredContentTypes) {
                    if (!contentType.startsWith(filteredContentType)) continue;
                    return vpb;
                }
            }
        }
        return null;
    }
}

