/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ipojo.interceptor.internal.handler;

import java.lang.reflect.Member;
import java.util.Date;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.ow2.jonas.ipojo.interceptor.ComponentInstanceState;
import org.ow2.jonas.ipojo.interceptor.IInstanceProvider;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class iPOJOInterceptor
extends PrimitiveHandler
implements IInstanceProvider,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(iPOJOInterceptor.class);
    private static final String CALLBACK_ELEMENT = "callback";
    private static final String METHOD_ATTRIBUTE = "method";
    private boolean __Fdeployable;
    private String deployable;
    private boolean __FstartTime;
    private Date startTime;
    private boolean __FshutdownTime;
    private Date shutdownTime;
    private boolean __Fthrowables;
    private Map<Throwable, Long> throwables;
    public static final String PREFIX_SOURCE = "ipojo/instance/";
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __MonError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable;
    private boolean __MstateChanged$int;
    private boolean __Mstop;
    private boolean __Mstart;
    private boolean __MgetName;
    private boolean __MgetStateComponent;
    private boolean __MgetDeployable;
    private boolean __MgetStartTime;
    private boolean __MgetUpTime;
    private boolean __MgetShutdownTime;
    private boolean __MgetThrowables;
    private boolean __MgetSource;
    private boolean __MgetInstanceDescription;

    String __getdeployable() {
        if (!this.__Fdeployable) {
            return this.deployable;
        }
        return (String)this.__IM.onGet((Object)this, "deployable");
    }

    void __setdeployable(String string) {
        if (!this.__Fdeployable) {
            this.deployable = string;
            return;
        }
        this.__IM.onSet((Object)this, "deployable", (Object)string);
    }

    Date __getstartTime() {
        if (!this.__FstartTime) {
            return this.startTime;
        }
        return (Date)this.__IM.onGet((Object)this, "startTime");
    }

    void __setstartTime(Date date) {
        if (!this.__FstartTime) {
            this.startTime = date;
            return;
        }
        this.__IM.onSet((Object)this, "startTime", (Object)date);
    }

    Date __getshutdownTime() {
        if (!this.__FshutdownTime) {
            return this.shutdownTime;
        }
        return (Date)this.__IM.onGet((Object)this, "shutdownTime");
    }

    void __setshutdownTime(Date date) {
        if (!this.__FshutdownTime) {
            this.shutdownTime = date;
            return;
        }
        this.__IM.onSet((Object)this, "shutdownTime", (Object)date);
    }

    Map __getthrowables() {
        if (!this.__Fthrowables) {
            return this.throwables;
        }
        return (Map)this.__IM.onGet((Object)this, "throwables");
    }

    void __setthrowables(Map map) {
        if (!this.__Fthrowables) {
            this.throwables = map;
            return;
        }
        this.__IM.onSet((Object)this, "throwables", (Object)map);
    }

    public iPOJOInterceptor() {
        this(null);
    }

    private iPOJOInterceptor(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setthrowables(new LinkedHashMap());
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__M_configure(element, dictionary);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element element, Dictionary dictionary) throws ConfigurationException {
        InstanceManager instanceManager = this.getInstanceManager();
        Element[] callbacks = element.getElements(CALLBACK_ELEMENT);
        if (callbacks != null) {
            for (Element callback : callbacks) {
                String name = callback.getAttribute(METHOD_ATTRIBUTE);
                MethodMetadata method = this.getPojoMetadata().getMethod(name);
                if (method == null) {
                    logger.warn((Object)("Could not register an interceptor for the method " + name + " of component " + this.getInstanceManager().getInstanceName() + " (method not found by PojoMetadata)"), new Object[0]);
                    continue;
                }
                instanceManager.register(method, (MethodInterceptor)this);
            }
        }
    }

    public void onError(Object pojo, Member method, Throwable throwable) {
        if (!this.__MonError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable) {
            this.__M_onError(pojo, method, throwable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable", new Object[]{pojo, method, throwable});
            this.__M_onError(pojo, method, throwable);
            this.__IM.onExit((Object)this, "onError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable", null);
        }
        catch (Throwable throwable2) {
            this.__IM.onError((Object)this, "onError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable", throwable2);
            throw throwable2;
        }
    }

    private void __M_onError(Object pojo, Member method, Throwable throwable) {
        this.__getthrowables().put(throwable, System.currentTimeMillis());
    }

    public void stateChanged(int state) {
        if (!this.__MstateChanged$int) {
            this.__M_stateChanged(state);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stateChanged$int", new Object[]{new Integer(state)});
            this.__M_stateChanged(state);
            this.__IM.onExit((Object)this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __M_stateChanged(int state) {
        switch (iPOJOInterceptor.adapt(state)) {
            case DISPOSED: 
            case INVALID: 
            case STOPPED: {
                this.__setshutdownTime(new Date());
                break;
            }
            case VALID: {
                this.__setstartTime(new Date());
                this.__setshutdownTime(null);
            }
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        logger.debug((Object)("iPOJO interceptor of " + this.getInstanceManager().getInstanceName() + " has been stopped."), new Object[0]);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        logger.debug((Object)("iPOJO interceptor start on pojo " + this.getInstanceManager().getInstanceName()), new Object[0]);
    }

    @Override
    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__M_getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__M_getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getName() {
        return this.getInstanceManager().getInstanceName();
    }

    @Override
    public ComponentInstanceState getStateComponent() {
        ComponentInstanceState componentInstanceState;
        if (!this.__MgetStateComponent) {
            return this.__M_getStateComponent();
        }
        try {
            this.__IM.onEntry((Object)this, "getStateComponent", new Object[0]);
            componentInstanceState = this.__M_getStateComponent();
            this.__IM.onExit((Object)this, "getStateComponent", (Object)componentInstanceState);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getStateComponent", throwable);
            throw throwable;
        }
        return componentInstanceState;
    }

    private ComponentInstanceState __M_getStateComponent() {
        return iPOJOInterceptor.adapt(this.getInstanceManager().getState());
    }

    private static ComponentInstanceState adapt(int state) {
        switch (state) {
            case -1: {
                return ComponentInstanceState.DISPOSED;
            }
            case 1: {
                return ComponentInstanceState.INVALID;
            }
            case 2: {
                return ComponentInstanceState.VALID;
            }
            case 0: {
                return ComponentInstanceState.STOPPED;
            }
        }
        throw new IllegalArgumentException("Invalid ComponentInstance state: " + state);
    }

    @Override
    public String getDeployable() {
        String string;
        if (!this.__MgetDeployable) {
            return this.__M_getDeployable();
        }
        try {
            this.__IM.onEntry((Object)this, "getDeployable", new Object[0]);
            string = this.__M_getDeployable();
            this.__IM.onExit((Object)this, "getDeployable", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeployable", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDeployable() {
        return null;
    }

    @Override
    public Date getStartTime() {
        Date date;
        if (!this.__MgetStartTime) {
            return this.__M_getStartTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getStartTime", new Object[0]);
            date = this.__M_getStartTime();
            this.__IM.onExit((Object)this, "getStartTime", (Object)date);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getStartTime", throwable);
            throw throwable;
        }
        return date;
    }

    private Date __M_getStartTime() {
        return this.__getstartTime();
    }

    @Override
    public Long getUpTime() {
        Long l;
        if (!this.__MgetUpTime) {
            return this.__M_getUpTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getUpTime", new Object[0]);
            l = this.__M_getUpTime();
            this.__IM.onExit((Object)this, "getUpTime", (Object)l);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUpTime", throwable);
            throw throwable;
        }
        return l;
    }

    private Long __M_getUpTime() {
        if (this.__getstartTime() != null) {
            Date lastTime = this.__getshutdownTime() == null ? new Date() : this.__getshutdownTime();
            return lastTime.getTime() - this.__getstartTime().getTime();
        }
        return null;
    }

    @Override
    public Date getShutdownTime() {
        Date date;
        if (!this.__MgetShutdownTime) {
            return this.__M_getShutdownTime();
        }
        try {
            this.__IM.onEntry((Object)this, "getShutdownTime", new Object[0]);
            date = this.__M_getShutdownTime();
            this.__IM.onExit((Object)this, "getShutdownTime", (Object)date);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShutdownTime", throwable);
            throw throwable;
        }
        return date;
    }

    private Date __M_getShutdownTime() {
        return this.__getshutdownTime();
    }

    @Override
    public Map<Throwable, Long> getThrowables() {
        Map<Throwable, Long> map;
        if (!this.__MgetThrowables) {
            return this.__M_getThrowables();
        }
        try {
            this.__IM.onEntry((Object)this, "getThrowables", new Object[0]);
            map = this.__M_getThrowables();
            this.__IM.onExit((Object)this, "getThrowables", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getThrowables", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<Throwable, Long> __M_getThrowables() {
        return this.__getthrowables();
    }

    @Override
    public String getSource() {
        String string;
        if (!this.__MgetSource) {
            return this.__M_getSource();
        }
        try {
            this.__IM.onEntry((Object)this, "getSource", new Object[0]);
            string = this.__M_getSource();
            this.__IM.onExit((Object)this, "getSource", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSource", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getSource() {
        return PREFIX_SOURCE + this.getName();
    }

    @Override
    public InstanceDescription getInstanceDescription() {
        InstanceDescription instanceDescription;
        if (!this.__MgetInstanceDescription) {
            return this.__M_getInstanceDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceDescription", new Object[0]);
            instanceDescription = this.__M_getInstanceDescription();
            this.__IM.onExit((Object)this, "getInstanceDescription", (Object)instanceDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceDescription", throwable);
            throw throwable;
        }
        return instanceDescription;
    }

    private InstanceDescription __M_getInstanceDescription() {
        return this.getInstanceManager().getInstanceDescription();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deployable")) {
                this.__Fdeployable = true;
            }
            if (set.contains("shutdownTime")) {
                this.__FshutdownTime = true;
            }
            if (set.contains("startTime")) {
                this.__FstartTime = true;
            }
            if (set.contains("throwables")) {
                this.__Fthrowables = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("onError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable")) {
                this.__MonError$java_lang_Object$java_lang_reflect_Member$java_lang_Throwable = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("getStateComponent")) {
                this.__MgetStateComponent = true;
            }
            if (set.contains("getDeployable")) {
                this.__MgetDeployable = true;
            }
            if (set.contains("getStartTime")) {
                this.__MgetStartTime = true;
            }
            if (set.contains("getUpTime")) {
                this.__MgetUpTime = true;
            }
            if (set.contains("getShutdownTime")) {
                this.__MgetShutdownTime = true;
            }
            if (set.contains("getThrowables")) {
                this.__MgetThrowables = true;
            }
            if (set.contains("getSource")) {
                this.__MgetSource = true;
            }
            if (set.contains("getInstanceDescription")) {
                this.__MgetInstanceDescription = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

