/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.jonas;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.ow2.jonas.launcher.jonas.DefaultConfigurationProvider;
import org.ow2.jonas.launcher.jonas.IConfigurationProvider;
import org.ow2.jonas.launcher.jonas.util.IOUtils;
import org.ow2.jonas.launcher.jonas.util.JOnASUtils;

public class JOnAS {
    private Framework framework;
    private static final String SECURITY_MANAGER = "jonas.security.manager";
    private static final String FRAMEWORK_FACTORY_PROPERTY = "META-INF/services/org.osgi.framework.launch.FrameworkFactory";
    private static final String TUI_BUNDLE_NAME_PROPERTY = "jonas-tui";
    private static final String GUI_BUNDLE_NAME_PROPERTY = "jonas-gui";
    private IConfigurationProvider provider = null;
    private String tuiBundleName;
    private String guiBundleName;
    private static final Logger LOGGER = Logger.getLogger(JOnAS.class.getName());

    public JOnAS(boolean forceCleanUp) throws Exception {
        System.out.print("\nWelcome to OW2 JOnAS");
        boolean useSecurityManager = new Boolean(JOnASUtils.getServerProperty(SECURITY_MANAGER, "true").trim());
        if (useSecurityManager && System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        this.initializeSystemProperties();
        this.provider = this.getConfigurationProvider();
        Map<String, String> configProps = this.provider.getConfiguration();
        this.tuiBundleName = configProps.get(TUI_BUNDLE_NAME_PROPERTY);
        this.guiBundleName = configProps.get(GUI_BUNDLE_NAME_PROPERTY);
        if (this.guiBundleName == null) {
            throw new Exception("Property not defined: jonas-gui");
        }
        if (forceCleanUp) {
            IOUtils.deleteDir(new File(configProps.get("org.osgi.framework.storage")));
        }
        this.framework = this.getFrameworkFactory().newFramework(configProps);
        this.framework.init();
        String version = this.framework.getBundleContext().getBundle(0L).getVersion().toString();
        System.out.println(" (Running on " + this.framework.getClass().getSimpleName() + " v" + version + ").");
        System.out.println("-----------------------------------------------\n");
        this.processBundles();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (JOnAS.this.framework.getState() == 32) {
                        JOnAS.this.framework.stop();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    public void start() throws Exception {
        this.framework.start();
        this.startTransientBundles();
        this.framework.waitForStop(0L);
        System.exit(0);
    }

    public void stop() throws Exception {
        if (this.framework.getState() == 32) {
            this.framework.stop();
        }
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return new DefaultConfigurationProvider();
    }

    public static void main(String[] args) throws Exception {
        JOnAS jonas = new JOnAS(Boolean.getBoolean("jonas.cache.clean"));
        jonas.start();
    }

    protected void initializeSystemProperties() {
        System.setProperty("jonas.start.date", Long.toString(System.currentTimeMillis()));
        System.setProperty("monolog.wrappers", "mx4j.log.CommonsLogger,mx4j.log.Logger,java.util.logging.Logger,org.apache.commons.logging.impl.Jdk14Logger,org.apache.juli.logging.impl.Jdk14Logger,org.ow2.util.log.JDKLogger,org.ow2.util.log.jul.internal.JDKLogger,org.apache.juli.logging.DirectJDKLog,org.jgroups.logging.JDKLogImpl,org.ow2.carol.util.configuration.TraceCarol,org.slf4j.impl.JCLLoggerAdapter");
        System.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        System.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.ow2.carol.util.delegate.UtilDelegateImpl");
        System.setProperty("java.naming.factory.initial", "org.ow2.carol.jndi.intercept.spi.InterceptorInitialContextFactory");
        this.setDefaultPropertyIfNotSet("java.security.policy", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/java.policy"));
        this.setDefaultPropertyIfNotSet("java.security.auth.login.config", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/jaas.config"));
        System.setProperty("javax.management.builder.initial", "org.ow2.jonas.services.bootstrap.mbeanbuilder.JOnASMBeanServerBuilder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkFactory getFrameworkFactory() throws Exception {
        ClassLoader frameworkClassLoader = this.provider.getFrameworkClassLoader(this.getClass().getClassLoader());
        URL url = frameworkClassLoader.getResource(FRAMEWORK_FACTORY_PROPERTY);
        if (url != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String s = br.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                        FrameworkFactory frameworkFactory = (FrameworkFactory)Class.forName(s, true, frameworkClassLoader).newInstance();
                        return frameworkFactory;
                    }
                    s = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        throw new Exception("Could not find any OSGi framework factory (no 'META-INF/services/org.osgi.framework.launch.FrameworkFactory' property found).");
    }

    protected void setDefaultPropertyIfNotSet(String key, String def) {
        System.setProperty(key, System.getProperty(key, def));
    }

    protected void startTransientBundles() throws BundleException {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.framework.getBundleContext().getBundles()) {
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName == null) continue;
            if (symbolicName.equals(this.tuiBundleName) && Boolean.getBoolean("jonas.felix.tui.enabled")) {
                this.startTransient(bundle);
            }
            if (!symbolicName.startsWith(this.guiBundleName) || !Boolean.getBoolean("jonas.felix.gui.enabled")) continue;
            this.startTransient(bundle);
        }
    }

    protected void processBundles() {
        BundleContext bundleContext = this.framework.getBundleContext();
        SortedMap<Integer, List<String>> autoInstallBundles = this.provider.getAutoInstallBundles();
        SortedMap<Integer, List<String>> autoStartBundles = this.provider.getAutoStartBundles();
        TreeSet<Integer> levels = new TreeSet<Integer>();
        levels.addAll(autoInstallBundles.keySet());
        levels.addAll(autoStartBundles.keySet());
        Iterator levelIterator = levels.iterator();
        ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
        while (levelIterator.hasNext()) {
            Bundle bundle;
            Integer level = (Integer)levelIterator.next();
            List autoInstallBundleLocations = (List)autoInstallBundles.get(level);
            List autoStartBundleLocations = (List)autoStartBundles.get(level);
            if (autoInstallBundleLocations != null && !autoInstallBundleLocations.isEmpty()) {
                for (String bundleLocation : autoInstallBundleLocations) {
                    bundle = this.isDeploy(bundleLocation);
                    if (bundle != null) continue;
                    try {
                        bundle = bundleContext.installBundle(bundleLocation);
                        bundle.adapt(BundleStartLevel.class).setStartLevel(level);
                    }
                    catch (BundleException e) {
                        LOGGER.log(Level.SEVERE, "Unable to install the bundle with location '" + bundleLocation + "' and the startlevel '" + level + "'.", e);
                    }
                }
            }
            if (autoStartBundleLocations == null || autoStartBundleLocations.isEmpty()) continue;
            for (String bundleLocation : autoStartBundleLocations) {
                bundle = this.isDeploy(bundleLocation);
                if (bundle == null) {
                    try {
                        bundle = bundleContext.installBundle(bundleLocation);
                        bundle.adapt(BundleStartLevel.class).setStartLevel(level);
                    }
                    catch (BundleException e) {
                        LOGGER.log(Level.SEVERE, "Unable to install the bundle with location '" + bundleLocation + "' and the startlevel '" + level + "'.", e);
                    }
                }
                if (bundle == null || bundle.getState() != 2 && bundle.getState() != 4) continue;
                bundlesToStart.add(bundle);
            }
        }
        for (Bundle bundle : bundlesToStart) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                LOGGER.log(Level.SEVERE, "Unable to start the bundle with name '" + bundle.getSymbolicName() + "'", e);
            }
        }
    }

    private Bundle isDeploy(String bundleLocation) {
        BundleContext bundleContext = this.framework.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundle.getLocation().equals(bundleLocation)) continue;
            return bundle;
        }
        return null;
    }

    protected void startTransient(Bundle bundle) throws BundleException {
        bundle.start(1);
    }

    public Framework getFramework() {
        return this.framework;
    }
}

