/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.Map;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.GenClassExtent;
import org.objectweb.util.monolog.api.BasicLevel;

public class JormAssignMapperRule
extends BasicRule {
    protected Map jormName2Mapper = null;
    protected Map jormName2Project = null;

    public JormAssignMapperRule() {
        super("JormAssignMapperRule");
    }

    public Map getJormName2Mapper() {
        return this.jormName2Mapper;
    }

    public void setJormName2Mapper(Map jormName2Mapper, Map jormName2Project) {
        this.jormName2Mapper = jormName2Mapper;
        this.jormName2Project = jormName2Project;
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        if (this.jormName2Mapper == null || this.jormName2Mapper.size() == 0) {
            throw new MedorException("Unable to assign the mapper on the jorm leaves without non empty map");
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Assignation of mappers");
        }
        this.assignMapper(qt);
        return qt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assignMapper(QueryTree qt) throws MedorException {
        if (qt instanceof ClassExtent) {
            ClassExtent extent = (ClassExtent)qt;
            String name = ((Class)extent.getMetaObject()).getFQName();
            PMapper mapper = (PMapper)this.jormName2Mapper.get(name);
            if (mapper == null) throw new MedorException("No mapper specified for the class " + name);
            extent.setPMapper(mapper, (String)this.jormName2Project.get(name));
            if (!this.debug) return;
            this.log.log(BasicLevel.DEBUG, (Object)("Assign the mapper " + mapper.getMapperName() + "to the ClassExtent" + extent.getName()));
            return;
        } else if (qt instanceof GenClassExtent) {
            GenClassExtent gce = (GenClassExtent)qt;
            GenClassRef gcr = (GenClassRef)gce.getMetaObject();
            String name = ((Class)gcr.getParent()).getFQName() + "." + gcr.getName();
            PMapper mapper = (PMapper)this.jormName2Mapper.get(name);
            if (mapper == null) throw new MedorException("No mapper specified for the GenClass " + name);
            gce.setPMapper(mapper, (String)this.jormName2Project.get(name));
            if (!this.debug) return;
            this.log.log(BasicLevel.DEBUG, (Object)("Assign the mapper " + mapper.getMapperName() + "to the GenClassExtent" + gce.getName()));
            return;
        } else {
            if (!(qt instanceof QueryNode)) return;
            QueryTree[] qts = ((QueryNode)qt).getChildren();
            for (int i = 0; i < qts.length; ++i) {
                this.assignMapper(qts[i]);
            }
        }
    }
}

