/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.jonas.antmodular.bootstrap.BootstrapTask;
import org.ow2.jonas.antmodular.bootstrap.JOnASAntTool;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.Tasks;

public abstract class AbstractJOnASBaseAntTask
extends Task {
    protected File jonasRoot = null;
    protected File destDir = null;
    protected List tasks = new ArrayList();
    protected static final String CONF_DIR = "/conf";

    protected AbstractJOnASBaseAntTask() {
    }

    public void execute() {
        this.jonasRoot = new File(this.getJOnASRoot());
        this.destDir = new File(this.getJOnASBase());
        if (this.jonasRoot == null) {
            throw new BuildException("jonasRoot element is not set");
        }
        if (this.destDir == null) {
            throw new BuildException("destDir element is not set");
        }
        if (this.jonasRoot.getPath().equals(this.destDir.getPath())) {
            throw new BuildException("jonasRoot and destDir is the same path !");
        }
    }

    public void executeAllTask() {
        for (Object o : this.tasks) {
            BaseTaskItf task;
            if (o instanceof BaseTaskItf) {
                task = (BaseTaskItf)o;
                task.setDestDir(this.destDir);
                task.setJonasRoot(this.jonasRoot);
                if (task instanceof BootstrapTask) {
                    ((BootstrapTask)((Object)task)).setJonasBase(this.destDir);
                }
                JOnASAntTool.configure(this, (Task)task);
                String info = task.getLogInfo();
                if (info != null) {
                    this.log(info, 2);
                }
                task.execute();
                continue;
            }
            task = (Task)o;
            JOnASAntTool.configure(this, (Task)task);
            task.execute();
        }
    }

    public void addTasks(Tasks subTasks) {
        if (subTasks != null) {
            Iterator<Task> it = subTasks.getTasks().iterator();
            while (it.hasNext()) {
                this.tasks.add(it.next());
            }
        }
    }

    public void addTask(BaseTaskItf task) {
        if (task != null) {
            this.tasks.add(task);
        }
    }

    public List getTasks() {
        return this.tasks;
    }

    protected JTask createServiceNameReplace(String serviceName, String info, String confDir, String property) {
        JTask jtask = new JTask();
        jtask.setDestDir(this.destDir);
        jtask.changeValueForKey(info, confDir, "jonas.properties", property, serviceName, false);
        jtask.setLogInfo(info + "Setting service to : " + serviceName);
        return jtask;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public String getJOnASRoot() {
        return this.getProject().getProperty("jonas.root");
    }

    public String getJOnASBase() {
        return this.getProject().getProperty("jonas.base");
    }
}

