/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.sed;

import aQute.libg.sed.Replacer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sed {
    final File file;
    final Replacer macro;
    File output;
    final Map<Pattern, String> replacements = new LinkedHashMap<Pattern, String>();

    public Sed(Replacer macro, File file) {
        assert (file.isFile());
        this.file = file;
        this.macro = macro;
    }

    public void setOutput(File f) {
        this.output = f;
    }

    public void replace(String pattern, String replacement) {
        this.replacements.put(Pattern.compile(pattern), replacement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt() throws IOException {
        BufferedReader brdr = new BufferedReader(new FileReader(this.file));
        File out = this.output != null ? this.output : new File(this.file.getAbsolutePath() + ".tmp");
        File bak = new File(this.file.getAbsolutePath() + ".bak");
        PrintWriter pw = new PrintWriter(new FileWriter(out));
        try {
            String line;
            while ((line = brdr.readLine()) != null) {
                for (Pattern p : this.replacements.keySet()) {
                    String replace = this.replacements.get(p);
                    Matcher m = p.matcher(line);
                    StringBuffer sb = new StringBuffer();
                    while (m.find()) {
                        String tmp = this.setReferences(m, replace);
                        tmp = this.macro.process(tmp);
                        m.appendReplacement(sb, Matcher.quoteReplacement(tmp));
                    }
                    m.appendTail(sb);
                    line = sb.toString();
                }
                pw.println(line);
            }
            pw.close();
            if (this.output == null) {
                this.file.renameTo(bak);
                out.renameTo(this.file);
            }
        }
        finally {
            brdr.close();
            pw.close();
        }
    }

    private String setReferences(Matcher m, String replace) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < replace.length(); ++i) {
            char c = replace.charAt(i);
            if (c == '$' && i < replace.length() - 1 && Character.isDigit(replace.charAt(i + 1))) {
                int n = replace.charAt(i + 1) - 48;
                if (n <= m.groupCount()) {
                    sb.append(m.group(n));
                }
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

