/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.basidir;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PBindingCtrl;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.api.PStateGraph;
import org.objectweb.jorm.facility.naming.basidir.BasidName;
import org.objectweb.jorm.facility.naming.generator.LongGen;
import org.objectweb.jorm.facility.naming.generator.LongGenMgr;
import org.objectweb.jorm.facility.naming.generator.LongGenMgrRegistry;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionExistingName;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNamingContext;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.CacheManager;
import org.objectweb.perseus.cache.api.FixableCacheEntry;

public class BasidBinder
implements PBinder,
PNamingContext {
    private static final String LONGGENMGRCLASS = "org.objectweb.jorm.facility.naming.generator.LongGenIncr";
    protected int codingType = -1;
    protected Object nullOValue = null;
    protected long nullValue = -1L;
    PName PNNULL = null;
    PName PNONULL = null;
    protected PType ptype = null;
    protected PClassMapping pcm = null;
    private CacheManager bindingcache = null;
    private LongGen longGen = null;

    public BasidBinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasidBinder(PMapper m, String genname, byte clact) throws PException {
        this();
        LongGenMgr lgm;
        Class clazz = LongGenMgrRegistry.class;
        synchronized (clazz) {
            lgm = LongGenMgrRegistry.getLongGenMgr(m);
            if (lgm == null) {
                try {
                    lgm = (LongGenMgr)Class.forName(m.cn2mn(LONGGENMGRCLASS) + "Mapping").newInstance();
                }
                catch (InstantiationException e) {
                    throw new PException(e, "Cannot create LongGenMgr: cannot instanciate.");
                }
                catch (IllegalAccessException e) {
                    throw new PException(e, "Cannot create LongGenMgr: cannot access.");
                }
                catch (ClassNotFoundException e) {
                    throw new PException(e, "Cannot create LongGenMgr: cannot load.");
                }
                lgm.init(m, clact);
                LongGenMgrRegistry.registerLonGenMgr(lgm);
            }
        }
        this.longGen = lgm.getLongGen(genname);
        this.codingType = 16;
        this.nullValue = -1L;
    }

    public BasidBinder(int codingtype) {
        this();
        this.codingType = codingtype;
    }

    public BasidBinder(int codingtype, Object nullValue) {
        this();
        this.codingType = codingtype;
        this.nullOValue = nullValue;
    }

    public BasidBinder(int codingtype, long nullValue) {
        this();
        this.codingType = codingtype;
        this.nullValue = nullValue;
    }

    public int getCodingType() {
        return this.codingType;
    }

    public void setCodingType(int codingType) {
        this.codingType = codingType;
    }

    public void setNulOValue(Object nullvalue) {
        this.nullOValue = nullvalue;
    }

    public void setNulValue(long nullvalue) {
        this.nullValue = nullvalue;
    }

    public boolean codingSupported(int codingtype) {
        return codingtype == this.codingType;
    }

    public PName decode(byte[] en) throws PExceptionNaming {
        return new BasidName(en, this);
    }

    public PName decodeAbstract(Object en, Object context) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeByte(byte en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeObyte(Byte en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeChar(char en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeOchar(Character en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeInt(int en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeOint(Integer en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeLong(long en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeOlong(Long en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeShort(short en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeOshort(Short en) throws PExceptionNaming, UnsupportedOperationException {
        return new BasidName(en, this);
    }

    public PName decodeString(String en) throws PExceptionNaming {
        switch (this.codingType) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return new BasidName(Long.parseLong(en), this);
            }
        }
        return new BasidName(en, this);
    }

    public PName decodeCharArray(char[] en) throws PExceptionNaming {
        return new BasidName(en, this);
    }

    public PName decodeDate(Date en) throws PExceptionNaming {
        return new BasidName(en, this);
    }

    public PName decodeBigInteger(BigInteger en) throws PExceptionNaming {
        return new BasidName(en, this);
    }

    public PName decodeBigDecimal(BigDecimal en) throws PExceptionNaming {
        return new BasidName(en, this);
    }

    public byte[] encode(PName pn) throws PExceptionNaming {
        if (pn.isNull()) {
            return (byte[])this.nullOValue;
        }
        if (this.codingType == 8192) {
            return (byte[])((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type");
    }

    public Object encodeAbstract(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return (BasidName)pn;
    }

    public byte encodeByte(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (byte)this.nullValue;
        }
        if (this.codingType == 1) {
            return (byte)((BasidName)pn).p;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public Byte encodeObyte(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (Byte)this.nullOValue;
        }
        if (this.codingType == 32) {
            return (Byte)((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public char encodeChar(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (char)this.nullValue;
        }
        if (this.codingType == 2) {
            return (char)((BasidName)pn).p;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public Character encodeOchar(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (Character)this.nullOValue;
        }
        if (this.codingType == 64) {
            return (Character)((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public int encodeInt(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (int)this.nullValue;
        }
        if (this.codingType == 8) {
            return (int)((BasidName)pn).p;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public Integer encodeOint(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (Integer)this.nullOValue;
        }
        if (this.codingType == 256) {
            return (Integer)((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public long encodeLong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return this.nullValue;
        }
        if (this.codingType == 16) {
            return ((BasidName)pn).p;
        }
        System.err.println("CT=" + this.codingType);
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public Long encodeOlong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (Long)this.nullOValue;
        }
        if (this.codingType == 512) {
            return (Long)((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public short encodeShort(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (short)this.nullValue;
        }
        if (this.codingType == 4) {
            return (short)((BasidName)pn).p;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public Short encodeOshort(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn.isNull()) {
            return (Short)this.nullOValue;
        }
        if (this.codingType == 128) {
            return (Short)((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public String encodeString(PName pn) throws PExceptionNaming {
        if (pn.isNull()) {
            return null;
        }
        switch (this.codingType) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return Long.toString(((BasidName)pn).p);
            }
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 16384: 
            case 32768: {
                return ((BasidName)pn).o.toString();
            }
            case 2048: {
                return "" + ((Date)((BasidName)pn).o).getTime();
            }
        }
        return "?";
    }

    public char[] encodeCharArray(PName pn) throws PExceptionNaming {
        if (pn.isNull()) {
            return (char[])this.nullOValue;
        }
        if (this.codingType == 4096) {
            return (char[])((BasidName)pn).o;
        }
        throw new PExceptionNaming("Unsupported coding type, expected: " + this.codingType);
    }

    public Date encodeDate(PName pn) throws PExceptionNaming {
        if (pn.isNull()) {
            return (Date)this.nullOValue;
        }
        if (this.codingType == 2048) {
            return (Date)((BasidName)pn).o;
        }
        throw new PExceptionNaming("[" + this.getClassName() + "]: unsupported coding type");
    }

    public BigInteger encodeBigInteger(PName pn) throws PExceptionNaming {
        if (pn.isNull()) {
            return (BigInteger)this.nullOValue;
        }
        if (this.codingType == 16384) {
            return (BigInteger)((BasidName)pn).o;
        }
        throw new PExceptionNaming("[" + this.getClassName() + "]: unsupported coding type");
    }

    public BigDecimal encodeBigDecimal(PName pn) throws PExceptionNaming {
        if (pn.isNull()) {
            return (BigDecimal)this.nullOValue;
        }
        if (this.codingType == 32768) {
            return (BigDecimal)((BasidName)pn).o;
        }
        throw new PExceptionNaming("[" + this.getClassName() + "]: unsupported coding type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PName export(Object conn, Object en) throws PException {
        BasidName pn = null;
        if (en == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: cannot export null!");
        }
        if (en instanceof BasidName) {
            if (((PName)en).getPNameManager() == this) {
                return (PName)en;
            }
            return new BasidName(en, this);
        }
        PBindingCtrl pb = (PBindingCtrl)en;
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)3);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Export unauthorized operation, current status:" + pb.getStatus());
        }
        if (this.longGen == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: export not supported by this binder with no generator.");
        }
        pn = new BasidName(this.longGen.genId(conn), this);
        if (this.bindingcache != null) {
            CacheManager cacheManager = this.bindingcache;
            synchronized (cacheManager) {
                if (this.bindingcache.lookup(pn) != null) {
                    throw new PExceptionExistingName("[" + this.getClassName() + "]: an object has been already export with the same identifier");
                }
                try {
                    this.bindingcache.fix(this.bindingcache.bind(pn, en));
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(pn);
        pb.setStatus(nextstate);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PName export(Object conn, Object en, Object hints) throws PException {
        BasidName pn = null;
        if (en == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: cannot export null!");
        }
        if (en instanceof PName && ((PName)en).getPNameManager() == this) {
            return (PName)en;
        }
        PBindingCtrl pb = (PBindingCtrl)en;
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)3);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Export unauthorized operation, current status:" + pb.getStatus());
        }
        if (this.longGen != null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: export with hints not support by this generator binder.");
        }
        if (en instanceof BasidName && ((PName)en).getPNameManager().equals(this)) {
            return (PName)en;
        }
        if (!(en instanceof PBinding)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: the item cannot be exported by this binder (PName or PBinding only): " + en);
        }
        if (hints == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this item cannot be exported by this binder");
        }
        pn = new BasidName(hints, this);
        if (this.bindingcache != null) {
            CacheManager cacheManager = this.bindingcache;
            synchronized (cacheManager) {
                if (this.bindingcache.lookup(pn) != null) {
                    throw new PExceptionExistingName("[" + this.getClassName() + "]: an object has been already export with the same identifier");
                }
                try {
                    this.bindingcache.fix(this.bindingcache.bind(pn, en));
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(pn);
        pb.setStatus(nextstate);
        return pn;
    }

    public PName getNull() {
        switch (this.codingType) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                return this.PNNULL;
            }
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                return this.PNONULL;
            }
            case 2: {
                return this.PNNULL;
            }
        }
        return this.PNONULL;
    }

    public void setNullPName(Object o) {
        if (o == null) {
            this.nullOValue = o;
        } else if (o instanceof BasidName) {
            this.nullOValue = ((BasidName)o).o;
            this.nullValue = ((BasidName)o).p;
        } else {
            this.nullOValue = o;
            if (o instanceof Byte) {
                this.nullValue = ((Byte)o).byteValue();
            } else if (o instanceof Short) {
                this.nullValue = ((Short)o).shortValue();
            } else if (o instanceof Integer) {
                this.nullValue = ((Integer)o).intValue();
            } else if (o instanceof Long) {
                this.nullValue = (Long)o;
            } else if (o instanceof Character) {
                this.nullValue = ((Character)o).charValue();
            }
        }
    }

    public PType getPType() {
        return this.ptype;
    }

    public String getClassName() {
        return this.ptype.getJormName();
    }

    public PName resolve(Object conn, PName pn) throws PException {
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is null");
        }
        if (!pn.getPNameManager().equals(this)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is not valid in this binder");
        }
        return pn;
    }

    public void setPType(PType pt) {
        this.ptype = pt;
    }

    public boolean supportDynamicComposite() {
        return false;
    }

    public boolean supportCompositeField(String fn, PType ft) {
        return false;
    }

    public boolean supportStaticComposite() {
        return false;
    }

    public void unexport(Object conn, PName pn) throws PException {
        byte nextstate;
        PBindingCtrl pb;
        if (pn.isNull()) {
            throw new PExceptionProtocol("[" + this.getClassName() + "]: cannot unexport with a null pname.");
        }
        if (this.bindingcache != null) {
            pb = null;
            CacheEntry ce = this.bindingcache.lookup(pn);
            if (ce != null) {
                pb = (PBindingCtrl)ce.getCeObject();
            }
            if (pb == null) {
                throw new PExceptionProtocol("Unauthorized operation: No Pbinding found");
            }
            nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)4);
            if (nextstate == 5) {
                throw new PExceptionProtocol("Unauthorized operation: status =" + pb.getStatus());
            }
        } else {
            throw new PExceptionProtocol("Unauthorized operation: No Pbinding can be found without a CacheManager");
        }
        pb.setStatus(nextstate);
    }

    public void unexport(Object conn, PName pn, Object hints) throws PException {
        CacheEntry ce;
        if (pn.isNull()) {
            throw new PExceptionProtocol("[" + this.getClassName() + "]: cannot unexport with a null pname.");
        }
        PBindingCtrl pb = null;
        if (hints instanceof PBindingCtrl) {
            pb = (PBindingCtrl)hints;
        } else if (this.bindingcache != null && (ce = this.bindingcache.lookup(pn)) != null) {
            pb = (PBindingCtrl)ce.getCeObject();
        }
        if (pb == null) {
            throw new PExceptionProtocol("Unauthorized operation: No Pbinding found");
        }
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)4);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Unauthorized operation: status =" + pb.getStatus());
        }
        pb.setStatus(nextstate);
    }

    public PBinding lookup(PName pn) throws PException {
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is null");
        }
        if (pn.isNull()) {
            return null;
        }
        if (this.bindingcache == null) {
            throw new PExceptionProtocol("No internal cache: should be managed externally!");
        }
        CacheEntry ce = this.bindingcache.lookup(pn);
        if (ce != null) {
            return (PBinding)ce.getCeObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(PName pn, PBindingCtrl pb) throws PException {
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is null");
        }
        if (pb == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is null");
        }
        if (!(pn instanceof BasidName)) {
            throw new PExceptionNaming("Can only bind CustomerPkPName");
        }
        if (!pn.getPNameManager().equals(this)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is not valid in this binder (" + ", \nthis:" + this + ", \nthis.type:" + this.getPType().getJormName() + ", \nthis.pcm:" + this.getBinderClassMapping() + ", \npn.pnc: " + pn.getPNameManager() + ", \npn.pnc.type: " + pn.getPNameManager().getPType().getJormName() + ", \npn.pnc.pcm: " + ((PBinder)pn.getPNameManager()).getBinderClassMapping() + ", \npn:" + pn + ")");
        }
        if (!pb.getPClassMapping().equals(this.pcm)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is not valid in this binder");
        }
        if (pn.isNull()) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this PName represent the null value");
        }
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)1);
        if (this.bindingcache != null) {
            CacheManager cacheManager = this.bindingcache;
            synchronized (cacheManager) {
                try {
                    this.bindingcache.fix(this.bindingcache.bind(pn, pb));
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(pn);
        pb.setStatus(nextstate);
    }

    public PClassMapping getBinderClassMapping() {
        return this.pcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(PBindingCtrl pb) throws PException {
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)2);
        if (nextstate == pb.getStatus()) {
            return;
        }
        if (pb == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is null");
        }
        PName pn = pb.getPName();
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this PBinding is not bounded with a pname");
        }
        if (!pb.getPClassMapping().equals(this.pcm)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pbinding is not valid in this binder");
        }
        if (this.bindingcache != null) {
            CacheManager cacheManager = this.bindingcache;
            synchronized (cacheManager) {
                try {
                    if (((FixableCacheEntry)((Object)this.bindingcache)).getCeFixCount() == 0) {
                        pb.setPName(null);
                        pb.setStatus(nextstate);
                    } else {
                        CacheEntry ce = this.bindingcache.lookup(pn);
                        if (ce != null) {
                            this.bindingcache.unfix(ce);
                        }
                    }
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(null);
        pb.setStatus(nextstate);
    }

    public CacheManager getCacheManager() {
        return this.bindingcache;
    }

    public void setCacheManager(CacheManager cm) throws PException {
        this.bindingcache = cm;
    }

    public void setPClassMapping(PClassMapping pcm) {
        this.pcm = pcm;
        try {
            switch (this.codingType) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: {
                    this.PNNULL = new BasidName(this.nullValue, this);
                    break;
                }
                default: {
                    this.PNONULL = new BasidName(this.nullOValue, this);
                    break;
                }
            }
        }
        catch (PExceptionNaming pn) {
            System.out.println("Very strange problem: this exception should really never happen!!");
            pn.printStackTrace();
        }
    }
}

