/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.jorm.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.BasicJormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.GenClassExtent;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.query.lib.JoinProject;
import org.objectweb.util.monolog.api.Logger;

public class QueryBuilder {
    public static Logger log = Log.getLoggerFactory().getLogger("org.objectweb.medor.query.jorm.lib.QueryBuilder");
    private static final String GENCLASS_ELEMENT_NAME = "genClassElement";
    private static int queryBuilderCounter = 0;
    private QueryBuilder m_parent = null;
    private JoinProject m_join = new JoinProject();
    private int m_id = 0;
    private Map m_fields = new HashMap();
    private Map m_projected = new HashMap();
    private Integer queryBuilderId;
    private Map m_joins = new HashMap();
    private static final String DOT = "\\.";

    public static synchronized Integer allocateQueryBuilderId() {
        return new Integer(queryBuilderCounter++);
    }

    public QueryBuilder() {
        this(null);
    }

    public QueryBuilder(QueryBuilder parent) {
        this.m_parent = parent;
        this.queryBuilderId = QueryBuilder.allocateQueryBuilderId();
    }

    public QueryTree getQueryTree() {
        return this.m_join;
    }

    public boolean contains(String path) {
        return this.m_fields.containsKey(path);
    }

    public void define(String name, QueryTreeField field) throws MedorException {
        if (this.m_fields.containsKey(name)) {
            throw new IllegalArgumentException("duplicate definition: " + name + ", old value: " + this.m_fields.get(name) + ", new value: " + field);
        }
        this.m_fields.put(name, field);
    }

    public QueryTreeField project(QueryTreeField qtf) throws MedorException {
        return this.project(qtf.getName(), qtf);
    }

    public QueryTreeField project(String alias, QueryTreeField qtf) throws MedorException {
        QueryTreeField result = (QueryTreeField)this.m_projected.get(qtf);
        if (result == null) {
            result = this.m_join.addPropagatedField(alias, qtf.getType(), new QueryTreeField[]{qtf});
            this.m_projected.put(qtf, result);
        }
        qtf.getQueryTree().getAnnotations().put(JormExtent.ANNOTATION_QUERYTREE_GROUP, this.queryBuilderId);
        return result;
    }

    private String name(String[] path, int length) {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        for (int i = 0; i < length; ++i) {
            buf.append(sep);
            buf.append(path[i]);
            sep = ".";
        }
        return buf.toString();
    }

    private int id() {
        if (this.m_parent == null) {
            return this.m_id++;
        }
        return this.m_parent.id();
    }

    private PNameField getPNameField(Field field) {
        if (field instanceof PNameField) {
            return (PNameField)field;
        }
        if (field instanceof PropagatedField) {
            return this.getPNameField(((PropagatedField)field).getPreviousFields()[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private PNameField join(QueryTreeField parent, String nodeName) throws MedorException {
        void var6_9;
        BasicJormExtent ext;
        PNameField ppnf = this.getPNameField(parent);
        if (ppnf.isClassPName()) {
            return ppnf;
        }
        Reference ref = ppnf.getReference();
        PNameField pnf = null;
        if (!(ref instanceof GenClassRef) && (pnf = (PNameField)this.m_joins.get(parent)) != null) {
            return pnf;
        }
        String name = nodeName == null ? parent.getName() : nodeName;
        String pnfname = "object" + this.id();
        if (ref instanceof ClassRef) {
            ClassRef cref = (ClassRef)ref;
            ext = new ClassExtent(cref.getMOClass(), name, pnfname, true);
        } else if (ref instanceof GenClassRef) {
            GenClassRef gcref = (GenClassRef)ref;
            ext = new GenClassExtent(gcref, name, pnfname, GENCLASS_ELEMENT_NAME);
        } else {
            throw new IllegalStateException("unknown ref type: " + ref.getClass());
        }
        var6_9.getAnnotations().put(JormExtent.ANNOTATION_QUERYTREE_GROUP, this.queryBuilderId);
        pnf = (PNameField)var6_9.getTupleStructure().getField(var6_9.getPNameFieldName());
        Equal cond = new Equal(new BasicFieldOperand(parent), new BasicFieldOperand(pnf));
        Expression filter = this.m_join.getQueryFilter();
        filter = filter == null ? cond : new And(filter, cond);
        this.m_join.setQueryFilter(filter);
        if (ref instanceof GenClassRef) {
            Object o = this.m_joins.get(parent);
            if (o == null) {
                this.m_joins.put(parent, pnf);
            } else {
                if (!(o instanceof List)) {
                    Object other = o;
                    o = new ArrayList();
                    ((List)o).add(other);
                    this.m_joins.put(parent, o);
                }
                ((List)o).add(pnf);
            }
        } else {
            this.m_joins.put(parent, pnf);
        }
        return pnf;
    }

    public QueryTreeField navigate(QueryTreeField parent, String field) throws MedorException {
        return this.navigate(parent, field, null);
    }

    /*
     * WARNING - void declaration
     */
    public QueryTreeField navigate(QueryTreeField parent, String field, String nodeName) throws MedorException {
        void var5_8;
        QueryTreeField qtf;
        String fq;
        PNameField pnf = this.join(parent, nodeName);
        QueryTree qt = pnf.getQueryTree();
        TupleStructure ts = qt.getTupleStructure();
        if (ts.contains(fq = qt.getName() + "." + field)) {
            qtf = (QueryTreeField)ts.getField(fq);
        } else if (qt instanceof ClassExtent) {
            ClassExtent extent = (ClassExtent)qt;
            Class klass = (Class)extent.getMetaObject();
            TypedElement te = klass.getTypedElement(field);
            if (te == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("No such field '").append(field);
                buf.append("' in '").append(klass.getFQName());
                buf.append("' from ").append(parent);
                Iterator it = klass.getAllFields().iterator();
                while (it.hasNext()) {
                    TypedElement el = (TypedElement)it.next();
                    buf.append(", ").append(el.getName());
                }
                throw new IllegalArgumentException(buf.toString());
            }
            qtf = extent.addField(te);
        } else {
            throw new IllegalStateException("wrong extent type: " + qt.getClass() + "\nfor field: " + field);
        }
        return var5_8;
    }

    private boolean isGenClassReference(QueryTreeField qtf) {
        PNameField pnf = this.getPNameField(qtf);
        if (pnf == null) {
            return false;
        }
        if (!pnf.isClassPName()) {
            return pnf.getReference() instanceof GenClassRef;
        }
        return false;
    }

    private QueryTreeField navigate(String[] path, int length, String alias) throws MedorException {
        String name = this.name(path, length);
        QueryTreeField qtf = (QueryTreeField)this.m_fields.get(alias == null ? name : alias);
        if (qtf != null) {
            return qtf;
        }
        if (length == 0) {
            throw new IllegalArgumentException("no such path: " + this.name(path, path.length));
        }
        QueryTreeField parent = this.navigate(path, length - 1, null);
        qtf = this.navigate(parent, path[length - 1], alias);
        if (this.isGenClassReference(qtf)) {
            qtf = this.navigate(qtf, GENCLASS_ELEMENT_NAME);
        }
        this.define(alias == null ? name : alias, qtf);
        return qtf;
    }

    public QueryTreeField navigate(String[] path) throws MedorException {
        return this.navigate(path, null);
    }

    public QueryTreeField navigate(String[] path, String alias) throws MedorException {
        return this.navigate(path, path.length, alias);
    }

    public QueryTreeField navigate(String path) throws MedorException {
        return this.navigate(path, path);
    }

    public QueryTreeField navigate(String path, String alias) throws MedorException {
        String[] parts = path.split(DOT);
        return this.navigate(parts, alias);
    }
}

