/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jmx.internal;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JManagementIdentifier;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJMXService
extends AbsServiceImpl
implements JmxService {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.jmx");
    private static org.ow2.util.log.Log log = LogFactory.getLog(BaseJMXService.class);
    private Map<Class<?>, JManagementIdentifier> identifiers = null;
    private MBeanServer jmxServer = null;
    private Registry modelerRegistry = null;
    private String mbeanServerID = null;
    private List<ObjectName> registeredMBeansObjectNames = null;
    private List<ObjectName> registeredModelMBeansObjectNames = null;
    private static final String[] PACKAGE_DESCRIPTORS = new String[]{"org.ow2.jonas.web.tomcat6", "org.ow2.jonas.server"};

    protected static Logger getLogger() {
        return logger;
    }

    public void setMBeanServerID(String serverId) {
        this.mbeanServerID = serverId;
    }

    public void setMBeanServer(MBeanServer mbs) {
        this.jmxServer = mbs;
    }

    public void doStart() throws ServiceException {
        this.identifiers = new Hashtable();
        this.registeredMBeansObjectNames = new ArrayList<ObjectName>();
        this.registeredModelMBeansObjectNames = new ArrayList<ObjectName>();
        if (this.jmxServer == null) {
            ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(this.mbeanServerID);
            if (mbeanServers.size() == 0) {
                throw new ServiceException("No MBean server found for id '" + this.mbeanServerID + "'.");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Use first MBean server ID found");
            }
            this.jmxServer = (MBeanServer)mbeanServers.get(0);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JMX Service initialized");
            }
        }
        this.modelerRegistry = this.getModelRegistry();
    }

    public void doStop() throws ServiceException {
        if (this.jmxServer != null) {
            int i;
            for (i = this.registeredMBeansObjectNames.size() - 1; i >= 0; --i) {
                this.unregisterMBean(this.registeredMBeansObjectNames.get(i));
            }
            for (i = this.registeredModelMBeansObjectNames.size() - 1; i >= 0; --i) {
                this.unregisterMBean(this.registeredModelMBeansObjectNames.get(i));
            }
        }
    }

    public MBeanServer getJmxServer() {
        return this.jmxServer;
    }

    public MBeanServerConnection getJmxServerConnection() {
        return this.jmxServer;
    }

    public void registerMBean(Object mbean, String objectName) {
        try {
            ObjectName on = ObjectName.getInstance(objectName);
            this.registerMBean(mbean, on);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.ERROR, (Object)(objectName + ":" + e));
        }
    }

    public void registerMBean(Object mbean, ObjectName objectName) {
        if (this.jmxServer == null) {
            logger.log(BasicLevel.ERROR, (Object)"JMX Server not yet initialized");
            return;
        }
        try {
            this.jmxServer.registerMBean(mbean, objectName);
            this.registeredMBeansObjectNames.add(objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.log(BasicLevel.WARN, (Object)(objectName + ":" + e));
        }
        catch (MBeanRegistrationException e) {
            logger.log(BasicLevel.ERROR, (Object)(objectName + ":" + e));
        }
        catch (NotCompliantMBeanException e) {
            logger.log(BasicLevel.ERROR, (Object)(objectName + ":" + e));
        }
    }

    public void unregisterMBean(ObjectName objectName) {
        if (this.jmxServer == null) {
            logger.log(BasicLevel.ERROR, (Object)"JMX Server not yet initialized");
            return;
        }
        try {
            this.jmxServer.unregisterMBean(objectName);
            this.registeredMBeansObjectNames.remove(objectName);
        }
        catch (InstanceNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)(objectName + ":" + e));
        }
        catch (MBeanRegistrationException e) {
            logger.log(BasicLevel.ERROR, (Object)(objectName + ":" + e));
        }
    }

    public ManagedBean findManagedBean(String name) {
        return this.modelerRegistry.findManagedBean(name);
    }

    public ModelMBean registerModelMBean(final Object mbean, final ObjectName objectName, final ManagedBean managedBean) throws Exception {
        IExecution<ModelMBean> exec;
        if (this.modelerRegistry == null) {
            logger.log(BasicLevel.ERROR, (Object)"Commons Modeler MBeans Registry not yet created");
            return null;
        }
        ClassLoader cl = mbean.getClass().getClassLoader();
        ExecutionResult res = RunnableHelper.execute((ClassLoader)cl, (IExecution)(exec = new IExecution<ModelMBean>(){

            public ModelMBean execute() throws Exception {
                ModelMBean modelMBean = managedBean.createMBean(mbean);
                BaseJMXService.this.jmxServer.registerMBean(modelMBean, objectName);
                BaseJMXService.this.registeredModelMBeansObjectNames.add(objectName);
                return modelMBean;
            }
        }));
        if (res.hasException()) {
            throw res.getException();
        }
        return (ModelMBean)res.getResult();
    }

    public void registerModelMBean(final Object mbean, final ObjectName objectName) throws Exception {
        IExecution<Void> exec;
        if (this.modelerRegistry == null) {
            logger.log(BasicLevel.ERROR, (Object)"Commons Modeler MBeans Registry not yet created");
            return;
        }
        ClassLoader cl = mbean.getClass().getClassLoader();
        ExecutionResult res = RunnableHelper.execute((ClassLoader)cl, (IExecution)(exec = new IExecution<Void>(){

            public Void execute() throws Exception {
                BaseJMXService.this.modelerRegistry.registerComponent(mbean, objectName, null);
                BaseJMXService.this.registeredModelMBeansObjectNames.add(objectName);
                return null;
            }
        }));
        if (res.hasException()) {
            throw res.getException();
        }
    }

    public void registerModelMBean(Object mbean, String objectName) throws Exception {
        this.registerModelMBean(mbean, ObjectName.getInstance(objectName));
    }

    public void unregisterModelMBean(ObjectName objectName) {
        if (this.modelerRegistry == null) {
            logger.log(BasicLevel.ERROR, (Object)"Modeler MBeans Registry not yet created");
            return;
        }
        this.modelerRegistry.unregisterComponent(objectName);
        this.registeredModelMBeansObjectNames.remove(objectName);
    }

    private Registry getModelRegistry() {
        Registry registry = Registry.getRegistry(null, null);
        ClassLoader cl = BaseJMXService.class.getClassLoader();
        for (int i = 0; i < PACKAGE_DESCRIPTORS.length; ++i) {
            registry.loadDescriptors(PACKAGE_DESCRIPTORS[i], cl);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            String[] as = registry.findManagedBeans();
            logger.log(BasicLevel.DEBUG, (Object)">>> List of all MBeans descriptors");
            for (int i = 0; i < as.length; ++i) {
                String s = ">>> " + i + ") " + as[i];
                logger.log(BasicLevel.DEBUG, (Object)s);
            }
            logger.log(BasicLevel.DEBUG, (Object)"<<< List of all MBeans descriptors");
        }
        return registry;
    }

    public void loadDescriptors(String packageName, ClassLoader cl) {
        if (cl == null) {
            cl = BaseJMXService.class.getClassLoader();
        }
        this.modelerRegistry.loadDescriptors(packageName, cl);
    }

    public <T> String registerMBean(T instance) throws Exception {
        String on = this.getObjectName(instance);
        this.registerModelMBean(instance, on);
        return on;
    }

    public <T> void unregisterMBean(T instance) throws Exception {
        String on = this.getObjectName(instance);
        this.unregisterModelMBean(new ObjectName(on));
    }

    public <T> String getObjectName(T instance) throws ServiceException {
        JManagementIdentifier<T> identifier = this.getIdentifier(instance);
        if (identifier != null) {
            identifier.setDomain(this.getDomainName());
            identifier.setServerName(this.getJonasServerName());
            StringBuilder sb = new StringBuilder();
            sb.append(identifier.getDomain());
            sb.append(":");
            sb.append(identifier.getTypeProperty());
            String additionnal = identifier.getAdditionnalProperties(instance);
            if (additionnal != null && !"".equals(additionnal)) {
                sb.append(",");
                sb.append(additionnal);
            }
            sb.append(",");
            sb.append("name=");
            sb.append(identifier.getNamePropertyValue(instance));
            return sb.toString();
        }
        return null;
    }

    private <T> JManagementIdentifier<T> getIdentifier(T instance) throws ServiceException {
        Class<?> clz = instance.getClass();
        if (this.identifiers.containsKey(clz)) {
            return this.identifiers.get(clz);
        }
        String mbeanClassname = instance.getClass().getName();
        String mbeanPackage = mbeanClassname.substring(0, mbeanClassname.lastIndexOf(".") + 1);
        String identifierClassname = mbeanPackage + "mbean." + clz.getSimpleName() + "Identifier";
        try {
            Class<JManagementIdentifier> cls = instance.getClass().getClassLoader().loadClass(identifierClassname).asSubclass(JManagementIdentifier.class);
            JManagementIdentifier id = cls.newInstance();
            this.identifiers.put(clz, id);
            return id;
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Identifier Class not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Identifier Class not instantiated", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Identifier Class not instantiated", (Throwable)e);
        }
    }
}

