/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.jonas.deployablemonitor.DeployableMonitorService;
import org.ow2.jonas.deployablemonitor.ExclusionFilenameFilter;
import org.ow2.jonas.deployablemonitor.LexicographicallyFileComparator;
import org.ow2.jonas.deployablemonitor.SortableFileDeployable;
import org.ow2.jonas.deployablemonitor.SortableFileDeployableComparator;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableMonitor
extends Thread {
    private static Log logger = LogFactory.getLog(DeployableMonitor.class);
    private List<File> directories = new LinkedList<File>();
    private boolean developmentMode = false;
    private int monitorInterval;
    private boolean stopped = false;
    private Map<File, Long> modifiedFiles = new WeakHashMap<File, Long>();
    private Map<File, IDeployable<?>> deployed = new ConcurrentHashMap();
    private Map<File, Long> fileLengths = new HashMap<File, Long>();
    private List<File> failed = new ArrayList<File>();
    private List<File> unknown = new ArrayList<File>();
    private IDeployerManager deployerManager = null;
    private boolean firstCheck = true;
    private ExclusionFilenameFilter filter = new ExclusionFilenameFilter();
    private DeployableMonitorService myService = null;
    private Comparator<SortableFileDeployable> sortDeployablesComparator = null;
    private BundleContext bundleContext = null;

    public DeployableMonitor(DeployableMonitorService service, BundleContext bundleContext) {
        this.myService = service;
        this.sortDeployablesComparator = new SortableFileDeployableComparator();
        this.bundleContext = bundleContext;
    }

    public void reset() {
        if (this.firstCheck) {
            return;
        }
        this.modifiedFiles.clear();
        this.deployed.clear();
        this.fileLengths.clear();
        for (File deployDirectory : this.directories) {
            File[] files = deployDirectory.listFiles(this.filter);
            if (files == null) continue;
            for (File file : files) {
                try {
                    IDeployable deployable;
                    IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
                    if (archive == null || !this.deployerManager.isDeployed(deployable = this.myService.getDeployableHelper().getDeployable(archive))) continue;
                    this.deployed.put(file, deployable);
                    this.fileLengths.put(file, DeployableMonitor.getFileSize(file));
                    this.hasBeenUpdated(file);
                }
                catch (Throwable t) {
                    logger.warn((Object)"Cannot reset file {0}", new Object[]{file, t});
                }
            }
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            if (this.developmentMode || this.firstCheck) {
                this.saveFileLengths();
                try {
                    Thread.sleep((long)((double)this.monitorInterval * 0.2));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread fail to sleep");
                }
                this.updateArchives();
                this.checkNewArchives();
                if (this.firstCheck) {
                    String failStartOnError = System.getProperty("jonas.start.nofail");
                    if (!this.developmentMode && failStartOnError != null && Boolean.parseBoolean(failStartOnError) && !this.failed.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("The deployment of " + this.failed.size() + " deployable");
                        if (this.failed.size() > 1) {
                            stringBuilder.append("s");
                        }
                        stringBuilder.append(" has failed. The server is going to shut down.");
                        logger.error((Object)stringBuilder.toString(), new Object[0]);
                        Bundle bundle = this.bundleContext.getBundle(0L);
                        try {
                            bundle.stop();
                        }
                        catch (BundleException e) {
                            logger.error((Object)("Cannot stop bundle " + bundle.getLocation()), new Object[]{e});
                        }
                    }
                    this.myService.firstCheckEnded();
                }
                this.firstCheck = false;
            }
            try {
                Thread.sleep((long)((double)this.monitorInterval * 0.8));
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread fail to sleep");
            }
        }
        return;
    }

    private void saveFileLengths() {
        this.fileLengths.clear();
        for (File deployDirectory : this.directories) {
            File[] files = deployDirectory.listFiles(this.filter);
            if (files == null) continue;
            for (File file : files) {
                try {
                    this.fileLengths.put(file, DeployableMonitor.getFileSize(file));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private static void checkFileCompleteness(File file) throws IOException {
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            fis.close();
        }
    }

    private static long getFileSize(File file) throws Exception {
        File[] childs;
        if (file.isFile()) {
            DeployableMonitor.checkFileCompleteness(file);
            return file.length();
        }
        long size = 0L;
        for (File child : childs = file.listFiles()) {
            size += DeployableMonitor.getFileSize(child);
        }
        return size;
    }

    private void checkNewArchives() {
        try {
            this.detectNewArchives();
        }
        catch (Exception e) {
            logger.error((Object)"Problem when trying to find and deploy new archives", new Object[]{e});
        }
        catch (Error e) {
            logger.error((Object)"Error when trying to find and deploy new archives", new Object[]{e});
        }
    }

    private void updateArchives() {
        try {
            this.checkModifiedDeployables();
        }
        catch (Exception e) {
            logger.error((Object)"Problem when checking current deployables", new Object[]{e});
        }
        catch (Error e) {
            logger.error((Object)"Error when checking current deployables", new Object[]{e});
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void detectNewArchives() {
        for (File deployDirectory : this.directories) {
            IDeployable deployable;
            IArchive archive;
            File[] files = deployDirectory.listFiles(this.filter);
            if (files == null) continue;
            Arrays.sort(files, new LexicographicallyFileComparator());
            if (this.firstCheck) {
                LinkedList<SortableFileDeployable> deployables = new LinkedList<SortableFileDeployable>();
                for (File f : files) {
                    archive = ArchiveManager.getInstance().getArchive((Object)f);
                    if (archive == null) {
                        logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{f});
                        continue;
                    }
                    try {
                        deployable = this.myService.getDeployableHelper().getDeployable(archive);
                    }
                    catch (DeployableHelperException e) {
                        this.failed.add(f);
                        logger.error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{archive, e});
                        continue;
                    }
                    deployables.add(new SortableFileDeployable(f, deployable));
                }
                Collections.sort(deployables, this.sortDeployablesComparator);
                ArrayList<File> filesToDeploy = new ArrayList<File>();
                for (SortableFileDeployable sortableFileDeployable : deployables) {
                    filesToDeploy.add(sortableFileDeployable.getFile());
                }
                if (filesToDeploy.size() > 0) {
                    logger.info((Object)"Deployables to deploy at startup: [{0}]", new Object[]{deployables});
                }
                files = filesToDeploy.toArray(new File[filesToDeploy.size()]);
            }
            LinkedHashMap<File, IDeployable> deployablesToDeploy = new LinkedHashMap<File, IDeployable>();
            for (File file : files) {
                if (this.deployed.containsKey(file) || this.fileLengthHasChanged(file)) continue;
                if (this.failed.contains(file)) {
                    if (!this.hasBeenUpdated(file)) continue;
                    this.failed.remove(file);
                }
                if ((archive = ArchiveManager.getInstance().getArchive((Object)file)) == null) {
                    logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{file});
                    continue;
                }
                try {
                    deployable = this.myService.getDeployableHelper().getDeployable(archive);
                }
                catch (DeployableHelperException e) {
                    this.failed.add(file);
                    logger.error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{archive, e});
                    continue;
                }
                if (UnknownDeployable.class.isInstance(deployable)) {
                    if (this.unknown.contains(file)) continue;
                    this.unknown.add(file);
                    logger.error((Object)"The archive ''{0}'' is flagged as unkwnown deployable. Do not deploy it", new Object[]{archive});
                    continue;
                }
                if (this.unknown.contains(file)) {
                    this.unknown.remove(file);
                    logger.info((Object)"The archive ''{0}'' is not anymore an unknown deployable, deploy it now as ''{1}''", new Object[]{archive, deployable});
                }
                try {
                    if (this.deployerManager.isDeployed(deployable) && !DeploymentPlanDeployable.class.isInstance(deployable)) {
                        this.deployed.put(file, deployable);
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.stopped) {
                    return;
                }
                deployablesToDeploy.put(file, deployable);
                logger.debug((Object)"Detect a new Deployable ''{0}'' and deploying it.", new Object[]{deployable});
            }
            try {
                List deploymentReports = this.deployerManager.deploy(new ArrayList(deployablesToDeploy.values()));
                for (Map.Entry entry : deployablesToDeploy.entrySet()) {
                    File file;
                    file = (File)entry.getKey();
                    IDeployable deployable2 = (IDeployable)entry.getValue();
                    IDeploymentReport deploymentReport = this.getDeploymentReport(deployable2, deploymentReports);
                    if (deploymentReport == null || deploymentReport.isDeploymentOk()) {
                        this.deployed.put(file, deployable2);
                        continue;
                    }
                    if (deploymentReport.getException() instanceof UnsupportedDeployerException) continue;
                    this.failed.add(file);
                    logger.error((Object)"DeployerException : Cannot deploy the deployable ''{0}''", new Object[]{deployable2, deploymentReport.getException()});
                }
                System.gc();
            }
            catch (RuntimeException e) {
                this.failed.addAll(deployablesToDeploy.keySet());
                for (IDeployable deployable3 : deployablesToDeploy.values()) {
                    logger.error((Object)"RuntimeException : Cannot deploy the deployable ''{0}''", new Object[]{deployable3, e});
                }
            }
            catch (Error e) {
                this.failed.addAll(deployablesToDeploy.keySet());
                for (IDeployable deployable4 : deployablesToDeploy.values()) {
                    logger.error((Object)"Error : Cannot deploy the deployable ''{0}''", new Object[]{deployable4, e});
                }
            }
        }
    }

    private IDeploymentReport getDeploymentReport(IDeployable deployable, List<IDeploymentReport> deploymentReports) {
        for (IDeploymentReport deploymentReport : deploymentReports) {
            if (!deploymentReport.getDeployable().equals(deployable)) continue;
            return deploymentReport;
        }
        return null;
    }

    protected long getLastModified(File archive) {
        if (archive.isFile()) {
            return archive.lastModified();
        }
        File[] files = archive.listFiles();
        long last = 0L;
        if (files != null) {
            for (File f : files) {
                last = Math.max(last, this.getLastModified(f));
            }
        }
        return last;
    }

    protected boolean hasBeenUpdated(File file) {
        if (this.fileLengthHasChanged(file)) {
            return false;
        }
        long previousLastModified = 0L;
        Long l = this.modifiedFiles.get(file);
        if (l != null) {
            previousLastModified = l;
        }
        long updatedModified = this.getLastModified(file);
        if (previousLastModified == 0L) {
            this.modifiedFiles.put(file, updatedModified);
            return false;
        }
        if (updatedModified > previousLastModified) {
            this.modifiedFiles.put(file, updatedModified);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkModifiedDeployables() {
        Iterator<File> fileIterator = this.failed.iterator();
        while (fileIterator.hasNext()) {
            File f = fileIterator.next();
            if (f.exists()) continue;
            fileIterator.remove();
        }
        Set<File> files = this.deployed.keySet();
        for (File f : files) {
            IDeployable<?> deployable = this.deployed.get(f);
            try {
                if (this.deployerManager.isDeployed(deployable)) continue;
                this.deployed.remove(f);
            }
            catch (Exception e) {
                this.deployed.remove(f);
            }
        }
        if (files == null) {
            return;
        }
        LinkedHashMap deployablesToUnDeploy = new LinkedHashMap();
        LinkedHashMap deployablesToUpdate = new LinkedHashMap();
        for (File f : files) {
            IDeployable<?> deployable = this.deployed.get(f);
            if (deployable == null) continue;
            if (!f.exists()) {
                logger.info((Object)"Deployable ''{0}'' has been removed on the filesystem, undeploy it", new Object[]{deployable});
                deployablesToUnDeploy.put(f, deployable);
                continue;
            }
            if (!this.hasBeenUpdated(f)) continue;
            logger.info((Object)"Deployable ''{0}'' has been updated, reloading it", new Object[]{deployable});
            deployablesToUpdate.put(f, deployable);
        }
        try {
            List deploymentReports = this.deployerManager.undeploy(new ArrayList(deployablesToUnDeploy.values()));
            for (Map.Entry entry : deployablesToUnDeploy.entrySet()) {
                File file = (File)entry.getKey();
                IDeployable iDeployable = (IDeployable)entry.getValue();
                IDeploymentReport deploymentReport = this.getDeploymentReport(iDeployable, deploymentReports);
                if (deploymentReport == null || deploymentReport.isDeploymentOk() || deploymentReport.getException() instanceof UnsupportedDeployerException) continue;
                logger.error((Object)("Undeploy of the deployable '" + iDeployable + "' has failed"), new Object[]{deploymentReport.getException()});
                this.failed.add(file);
            }
            System.gc();
        }
        catch (RuntimeException e) {
            try {
                for (Map.Entry entry : deployablesToUnDeploy.entrySet()) {
                    logger.error((Object)("Undeploy of the deployable '" + entry.getValue() + "' has failed"), new Object[]{e});
                    this.failed.add((File)entry.getKey());
                }
            }
            catch (Throwable throwable) {
                for (File file : deployablesToUnDeploy.keySet()) {
                    this.deployed.remove(file);
                }
                throw throwable;
            }
            for (File file : deployablesToUnDeploy.keySet()) {
                this.deployed.remove(file);
            }
        }
        for (File file : deployablesToUnDeploy.keySet()) {
            this.deployed.remove(file);
        }
        boolean undeploymentIsOk = true;
        List deploymentReports = this.deployerManager.undeploy(new ArrayList(deployablesToUpdate.values()));
        for (Map.Entry entry : deployablesToUpdate.entrySet()) {
            File file = (File)entry.getKey();
            IDeployable deployable = (IDeployable)entry.getValue();
            IDeploymentReport deploymentReport = this.getDeploymentReport(deployable, deploymentReports);
            if (deploymentReport != null && !deploymentReport.isDeploymentOk()) {
                if (!(deploymentReport.getException() instanceof UnsupportedDeployerException)) {
                    logger.error((Object)("Undeploy of the deployable '" + deployable + "' has failed"), new Object[]{deploymentReport.getException()});
                    this.failed.add(file);
                } else {
                    undeploymentIsOk = false;
                }
            }
            if (!undeploymentIsOk) continue;
            this.deployed.remove(file);
        }
        System.gc();
        if (undeploymentIsOk) {
            LinkedHashMap<File, IDeployable> newDeployables = new LinkedHashMap<File, IDeployable>();
            for (File file : deployablesToUpdate.keySet()) {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
                if (archive == null) {
                    logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{file});
                    continue;
                }
                try {
                    newDeployables.put(file, this.myService.getDeployableHelper().getDeployable(archive));
                }
                catch (DeployableHelperException e) {
                    logger.error((Object)("Cannot get a deployable for the archive '" + archive + "'"), new Object[]{e});
                }
            }
            deploymentReports = this.deployerManager.deploy(new ArrayList(newDeployables.values()));
            for (Map.Entry entry : newDeployables.entrySet()) {
                File file = (File)entry.getKey();
                IDeployable deployable = (IDeployable)entry.getValue();
                IDeploymentReport deploymentReport = this.getDeploymentReport(deployable, deploymentReports);
                if (deploymentReport == null || deploymentReport.isDeploymentOk()) {
                    this.deployed.put(file, deployable);
                    continue;
                }
                if (deploymentReport.getException() instanceof UnsupportedDeployerException) continue;
                this.failed.add(file);
                logger.error((Object)"Error : Cannot redeploy the deployable ''{0}''", new Object[]{deployable, deploymentReport.getException()});
            }
            System.gc();
        }
    }

    private boolean fileLengthHasChanged(File file) {
        if (!this.fileLengths.containsKey(file)) {
            return true;
        }
        long storedFileLength = this.fileLengths.get(file);
        long currentFileLength = 0L;
        try {
            currentFileLength = DeployableMonitor.getFileSize(file);
        }
        catch (Exception e) {
            return true;
        }
        return storedFileLength != currentFileLength;
    }

    public List<File> getDirectories() {
        return this.directories;
    }

    public void setDirectories(List<File> directories) {
        this.directories = directories;
    }

    public void addDirectory(File directory) {
        this.directories.add(directory);
    }

    public void removeDirectory(File directory) {
        this.directories.remove(directory);
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.developmentMode = developmentMode;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void stopOrder() {
        this.stopped = true;
    }

    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setExclusionPatterns(List<String> patterns) {
        this.filter.setExclusionList(patterns);
    }

    public Comparator<SortableFileDeployable> getSortDeployablesComparator() {
        return this.sortDeployablesComparator;
    }

    public void setSortDeployablesComparator(Comparator<SortableFileDeployable> sortDeployablesComparator) {
        this.sortDeployablesComparator = sortDeployablesComparator;
    }
}

