/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.configadmin.internal.generic;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.ow2.jonas.configadmin.AdapterException;
import org.ow2.jonas.configadmin.ConfigurationInfo;
import org.ow2.jonas.configadmin.internal.generic.AbstractConfigurationAdapter;
import org.ow2.jonas.configadmin.internal.model.ConfigurationType;
import org.ow2.jonas.configadmin.internal.model.PropertyType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFactoryConfigurationAdapter
extends AbstractConfigurationAdapter {
    private static final Log logger = LogFactory.getLog(DefaultFactoryConfigurationAdapter.class);

    @Override
    public Set<ConfigurationInfo> convert(Element node) throws AdapterException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Node)node, ConfigurationType.class);
            ConfigurationType factoryConfiguration = (ConfigurationType)element.getValue();
            String servicePid = factoryConfiguration.getPid();
            ConfigurationInfo info = new ConfigurationInfo(servicePid, true);
            logger.debug((Object)"Creating FactoryConfiguration for pid {{0}}", new Object[]{servicePid});
            Map<String, Object> properties = info.getProperties();
            for (PropertyType property : factoryConfiguration.getProperties()) {
                properties.put(property.getName(), property.getValue());
            }
            logger.debug((Object)"Resulting Configuration: {{0}}", new Object[]{info});
            return Collections.singleton(info);
        }
        catch (JAXBException e) {
            logger.warn((Object)"Cannot unmarshall node {{0}}.", new Object[]{node, e});
            return null;
        }
    }
}

