/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.jorm.lib;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameCoder;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.lib.TuplePNameGetter;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.util.monolog.api.BasicLevel;

public class CompositePName
extends BasicOperator
implements Operator {
    protected String[] cofns = null;
    protected TuplePNameGetter myGetter = null;

    public CompositePName(FieldOperand[] fs, String[] compositefieldnames, Operand po, PType t) throws MedorException {
        super(t);
        boolean debug;
        this.expressions = new Expression[fs.length + 1];
        this.expressions[0] = po;
        System.arraycopy(fs, 0, this.expressions, 1, fs.length);
        this.cofns = compositefieldnames;
        HashMap<String, Integer> name2Index = new HashMap<String, Integer>(fs.length);
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Composite PName for " + fs.length + " fields"));
        }
        for (int i = 0; i < fs.length; ++i) {
            QueryTreeField qtf = (QueryTreeField)fs[i].getField();
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Field " + qtf.getName()));
                Field[] tsf = qtf.getQueryTree().getTupleStructure().getFields();
                this.logger.log(BasicLevel.DEBUG, (Object)"Fields of qt:");
                for (int jj = 0; jj < tsf.length; ++jj) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Field name " + tsf[jj].getName()));
                }
            }
            int rank = qtf.getQueryTree().getTupleStructure().getFieldRank(qtf);
            name2Index.put(compositefieldnames[i], new Integer(rank));
        }
        this.myGetter = new TuplePNameGetter(name2Index, po, this.logger);
    }

    public String[] getCompositeFieldName() {
        return this.cofns;
    }

    public ParameterOperand getPNameManagerParameter() {
        return this.expressions[0] instanceof ParameterOperand ? (ParameterOperand)this.expressions[0] : null;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((CompositePName)clone).cofns = this.cofns;
        if (this.myGetter != null) {
            ((CompositePName)clone).myGetter = new TuplePNameGetter(this.myGetter);
        }
        return clone;
    }

    public Operand getResult() throws IllegalStateException {
        if (this.verified) {
            return this.result;
        }
        throw new IllegalStateException("Can't get result of an uncompiled expression");
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        this.expressions[0].evaluate(pos, o);
        if (this.result == null) {
            this.result = new BasicVariableOperand(this.type);
        }
        PNameCoder pnc = (PNameCoder)((Operand)this.expressions[0]).getObject();
        try {
            PName pn = pnc.decodeAbstract(this.myGetter, o);
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("PName built: " + pn));
            }
            this.result.setValue(pn);
        }
        catch (PException pe) {
            throw new ExpressionException("Problem for builing composite PName from tuple", pe);
        }
        return this.result;
    }

    public Operand compileExpression() throws TypingException, MalformedExpressionException {
        if (this.expressions == null || this.expressions.length <= 1) {
            throw new MalformedExpressionException("null children value");
        }
        this.result = new BasicVariableOperand(this.type);
        this.verified = true;
        return this.result;
    }

    public FieldOperand[] getFields() {
        FieldOperand[] res = new FieldOperand[this.expressions.length - 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (FieldOperand)this.expressions[i + 1];
        }
        return res;
    }

    public String getOperatorString() {
        return "compositePName";
    }
}

