/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.util.LinkedList;
import javax.naming.Context;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.medor.eval.prefetch.api.PrefetchCache;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.jorm.JormFactory;

public class TxListener
implements Synchronization {
    private JEntityFactory bf;
    private Transaction tx;
    private LinkedList ctxList = new LinkedList();
    private LinkedList additionalContexts = new LinkedList();
    private boolean inStoreInstances = false;

    public TxListener(JEntityFactory bf, Transaction tx) {
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf = bf;
        this.tx = tx;
    }

    public synchronized void storeInstances() {
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
        }
        this.inStoreInstances = true;
        this.storeInstances(this.ctxList);
        while (!this.additionalContexts.isEmpty()) {
            LinkedList lst = new LinkedList();
            lst.addAll(this.additionalContexts);
            this.additionalContexts.clear();
            this.storeInstances(lst);
            this.ctxList.addAll(lst);
        }
        this.inStoreInstances = false;
    }

    public synchronized void removeInstance(JEntityContext ec) {
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
        }
        if (!this.ctxList.remove(ec) && !this.additionalContexts.remove(ec)) {
            TraceEjb.txlistener.log(BasicLevel.WARN, (Object)"Not in the list");
        }
    }

    public synchronized void addInstance(JEntityContext ec) {
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)ec.getEntityFactory().getEJBName());
        }
        if (this.inStoreInstances) {
            this.additionalContexts.addLast(ec);
        } else {
            this.ctxList.addLast(ec);
        }
    }

    public void beforeCompletion() {
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.bf.myClassLoader());
        Context bnctx = this.bf.setComponentContext();
        this.storeInstances();
        this.bf.resetComponentContext(bnctx);
        Thread.currentThread().setContextClassLoader(old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        PMapper mapper;
        PrefetchCache pc;
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
        }
        TxListener txListener = this;
        synchronized (txListener) {
            for (JEntityContext ec : this.ctxList) {
                ec.afterCompletion(status);
            }
        }
        if (this.bf instanceof JormFactory && (pc = (mapper = ((JormFactory)this.bf).getMapper()).getPrefetchCache()) != null) {
            pc.invalidatePrefetchBuffer(this.tx);
        }
        this.bf.removeTxListener(this.tx);
    }

    private void storeInstances(LinkedList contexts) {
        if (TraceEjb.isDebugTxlistener()) {
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)"");
        }
        for (JEntityContext ec : contexts) {
            ec.beforeCompletion();
            if (!TraceEjb.isDebugTxlistener()) continue;
            TraceEjb.txlistener.log(BasicLevel.DEBUG, (Object)("ec.beforeCompletion() on" + ec.getEntityFactory().getEJBName()));
        }
    }
}

