/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Filter;

public class Event {
    private final String topic;
    private final Map properties;

    public Event(String topic, Map properties) {
        Event.validateTopicName(topic);
        this.topic = topic;
        int size = properties == null ? 1 : properties.size() + 1;
        HashMap p = new HashMap(size);
        if (properties != null) {
            Iterator iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!(key instanceof String)) continue;
                Object value = properties.get(key);
                p.put(key, value);
            }
        }
        p.put("event.topics", topic);
        this.properties = p;
    }

    public Event(String topic, Dictionary properties) {
        Event.validateTopicName(topic);
        this.topic = topic;
        int size = properties == null ? 1 : properties.size() + 1;
        HashMap p = new HashMap(size);
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                if (!(key instanceof String)) continue;
                Object value = properties.get(key);
                p.put(key, value);
            }
        }
        p.put("event.topics", topic);
        this.properties = p;
    }

    public final Object getProperty(String name) {
        return this.properties.get(name);
    }

    public final String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public final String getTopic() {
        return this.topic;
    }

    public final boolean matches(Filter filter) {
        return filter.matchCase(new UnmodifiableDictionary(this.properties));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Event)) {
            return false;
        }
        Event event = (Event)object;
        return this.topic.equals(event.topic) && ((Object)this.properties).equals(event.properties);
    }

    public int hashCode() {
        int h = 527 + this.topic.hashCode();
        h = 31 * h + ((Object)this.properties).hashCode();
        return h;
    }

    public String toString() {
        return this.getClass().getName() + " [topic=" + this.topic + "]";
    }

    private static void validateTopicName(String topic) {
        char[] chars = topic.toCharArray();
        int length = chars.length;
        if (length == 0) {
            throw new IllegalArgumentException("empty topic");
        }
        for (int i = 0; i < length; ++i) {
            char ch = chars[i];
            if (ch == '/') {
                if (i == 0 || i == length - 1) {
                    throw new IllegalArgumentException("invalid topic: " + topic);
                }
                if (chars[i - 1] != '/') continue;
                throw new IllegalArgumentException("invalid topic: " + topic);
            }
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '_' || ch == '-') continue;
            throw new IllegalArgumentException("invalid topic: " + topic);
        }
    }

    private static class UnmodifiableDictionary
    extends Dictionary {
        private final Map wrapped;

        UnmodifiableDictionary(Map wrapped) {
            this.wrapped = wrapped;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.wrapped.values());
        }

        public Object get(Object key) {
            return this.wrapped.get(key);
        }

        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        public Enumeration keys() {
            return Collections.enumeration(this.wrapped.keySet());
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.wrapped.size();
        }
    }
}

