/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.server.info.internal;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.endpoint.collector.util.Util;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.server.info.generated.DateTimeType;
import org.ow2.jonas.report.extensions.server.info.generated.ServerInfo;
import org.ow2.jonas.service.report.util.Utility;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ServerInfoReportExtension
implements IReportExtension,
Pojo {
    private InstanceManager __IM;
    private static final String JONAS_ROOT = System.getProperty("jonas.root");
    private static final String JONAS_BASE = System.getProperty("jonas.base");
    public static final Log logger = LogFactory.getLog(ServerInfoReportExtension.class);
    public static final String XSD_PATH = "xsd/server-report.xsd";
    private boolean __Fj2EEServerService;
    private J2EEServerService j2EEServerService;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;
    private boolean __MbindJ2EEService$org_ow2_jonas_management_J2EEServerService;
    private boolean __MunbindJ2EEService$org_ow2_jonas_management_J2EEServerService;
    private boolean __MbindJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MunbindJmxService$org_ow2_jonas_jmx_JmxService;

    J2EEServerService __getj2EEServerService() {
        if (!this.__Fj2EEServerService) {
            return this.j2EEServerService;
        }
        return (J2EEServerService)this.__IM.onGet((Object)this, "j2EEServerService");
    }

    void __setj2EEServerService(J2EEServerService j2EEServerService) {
        if (!this.__Fj2EEServerService) {
            this.j2EEServerService = j2EEServerService;
            return;
        }
        this.__IM.onSet((Object)this, "j2EEServerService", (Object)j2EEServerService);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    public ServerInfoReportExtension() {
        this(null);
    }

    private ServerInfoReportExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        ServerInfo serverInfo = new ServerInfo();
        if (this.__getj2EEServerService() != null) {
            ObjectName objectName = Util.getObjectName((String)(this.__getjmxService().getDomainName() + ":j2eeType=J2EEServer,name=" + this.__getjmxService().getJonasServerName()));
            MBeanServer mBeanServer = this.__getjmxService().getJmxServer();
            String state = String.valueOf(Util.getMBeanAttributeValue((ObjectName)objectName, (String)"state", (MBeanServer)mBeanServer));
            String version = String.valueOf(Util.getMBeanAttributeValue((ObjectName)objectName, (String)"serverVersion", (MBeanServer)mBeanServer));
            Date startTime = new Date(Long.valueOf(String.valueOf(Util.getMBeanAttributeValue((ObjectName)objectName, (String)"startTime", (MBeanServer)mBeanServer))));
            String upTime = String.valueOf(Util.getMBeanAttributeValue((ObjectName)objectName, (String)"uptime", (MBeanServer)mBeanServer));
            if (startTime != null) {
                DateTimeType dateTime = new DateTimeType();
                dateTime.setDateTime(Utility.date2XMLGregorianCalendar((Date)startTime));
                dateTime.setTimestamp(BigInteger.valueOf(startTime.getTime()));
                serverInfo.setStartTime(dateTime);
            }
            if (upTime != null) {
                Long upTimLong = Long.valueOf(upTime);
                DateTimeType dateTime = new DateTimeType();
                dateTime.setDateTime(Utility.date2XMLGregorianCalendar((Date)new Date(upTimLong)));
                dateTime.setTimestamp(BigInteger.valueOf(upTimLong));
                serverInfo.setUpTime(dateTime);
            }
            serverInfo.setState(state);
            serverInfo.setJonasRoot(JONAS_ROOT);
            serverInfo.setJonasBase(JONAS_BASE);
            serverInfo.setVersion(version);
        }
        return serverInfo;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/server-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return ServerInfo.class;
    }

    public void bindJ2EEService(J2EEServerService j2EEServerService) {
        if (!this.__MbindJ2EEService$org_ow2_jonas_management_J2EEServerService) {
            this.__M_bindJ2EEService(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJ2EEService$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__M_bindJ2EEService(j2EEServerService);
            this.__IM.onExit((Object)this, "bindJ2EEService$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJ2EEService$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __M_bindJ2EEService(J2EEServerService j2EEServerService) {
        this.__setj2EEServerService(j2EEServerService);
    }

    public void unbindJ2EEService(J2EEServerService j2EEServerService) {
        if (!this.__MunbindJ2EEService$org_ow2_jonas_management_J2EEServerService) {
            this.__M_unbindJ2EEService(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJ2EEService$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__M_unbindJ2EEService(j2EEServerService);
            this.__IM.onExit((Object)this, "unbindJ2EEService$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJ2EEService$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __M_unbindJ2EEService(J2EEServerService j2EEServerService) {
    }

    public void bindJmxService(JmxService jmxService) {
        if (!this.__MbindJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_bindJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_bindJmxService(jmxService);
            this.__IM.onExit((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_bindJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void unbindJmxService(JmxService jmxService) {
        if (!this.__MunbindJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_unbindJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_unbindJmxService(jmxService);
            this.__IM.onExit((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_unbindJmxService(JmxService jmxService) {
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("j2EEServerService")) {
                this.__Fj2EEServerService = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
            if (set.contains("bindJ2EEService$org_ow2_jonas_management_J2EEServerService")) {
                this.__MbindJ2EEService$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("unbindJ2EEService$org_ow2_jonas_management_J2EEServerService")) {
                this.__MunbindJ2EEService$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("bindJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MbindJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("unbindJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MunbindJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

