/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.datasource;

import java.sql.Connection;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerInfo;
import org.ow2.jonas.jndi.checker.api.ResourceCheckpoints;
import org.ow2.jonas.jndi.interceptors.impl.datasource.ConnectionProxy;

public class TransactionalConnectionProxy
extends ConnectionProxy
implements Synchronization {
    private Transaction transaction;
    private boolean isClosed = false;

    public TransactionalConnectionProxy(Connection delegate, Transaction transaction) {
        super(delegate);
        this.transaction = transaction;
    }

    protected void unregisterConnection() {
        this.isClosed = true;
    }

    public void registerConnection() {
        try {
            this.transaction.registerSynchronization((Synchronization)this);
        }
        catch (RollbackException e) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (!this.isClosed) {
            TransactionalCheckerInfo info = null;
            switch (status) {
                case 3: {
                    info = new TransactionalCheckerInfo(ResourceCheckpoints.TRANSACTION_COMMITTED, this.transaction);
                    break;
                }
                case 4: {
                    info = new TransactionalCheckerInfo(ResourceCheckpoints.TRANSACTION_ROLLEDBACK, this.transaction);
                }
            }
            if (info != null) {
                this.autoCloseOrWarn(info);
            }
        }
    }

    private class TransactionalCheckerInfo
    implements IResourceCheckerInfo {
        private ResourceCheckpoints checkpoint;
        private Transaction transaction;

        public TransactionalCheckerInfo(ResourceCheckpoints checkpoint, Transaction transaction) {
            this.checkpoint = checkpoint;
            this.transaction = transaction;
        }

        public ResourceCheckpoints getCheckPoint() {
            return this.checkpoint;
        }

        public String getCallerInfo() {
            return this.transaction.toString();
        }
    }
}

