/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.PrimitiveInstanceDescription;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.api.ServiceProperty;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class Service
implements HandlerConfiguration {
    public static final int SINGLETON_STRATEGY = 0;
    public static final int STATIC_STRATEGY = 2;
    public static final int INSTANCE_STRATEGY = 3;
    public static final int SERVICE_STRATEGY = 1;
    private List m_specifications;
    private int m_strategy = 0;
    private String m_customStrategy;
    private List m_properties = new ArrayList();
    private String m_controller;
    private boolean m_controllerValue;
    static /* synthetic */ Class class$java$lang$String;

    public Element getElement() {
        this.ensureValidity();
        Element element = new Element("provides", "");
        if (this.m_specifications != null) {
            element.addAttribute(new Attribute("specifications", this.getSpecificationsArray()));
        }
        element.addAttribute(new Attribute("strategy", this.getStringStrategy()));
        for (int i = 0; i < this.m_properties.size(); ++i) {
            element.addElement(((ServiceProperty)this.m_properties.get(i)).getElement());
        }
        if (this.m_controller != null) {
            Element ctrl = new Element("controller", "");
            ctrl.addAttribute(new Attribute("field", this.m_controller));
            ctrl.addAttribute(new Attribute("value", String.valueOf(this.m_controllerValue)));
            element.addElement(ctrl);
        }
        return element;
    }

    public ProvidedServiceDescription getProvidedServiceDescription(ComponentInstance instance) {
        PrimitiveInstanceDescription desc = (PrimitiveInstanceDescription)instance.getInstanceDescription();
        ProvidedServiceDescription[] pss = desc.getProvidedServices();
        if (pss.length == 0) {
            return null;
        }
        if (pss.length == 1) {
            return pss[0];
        }
        if (this.m_specifications == null) {
            return null;
        }
        for (int j = 0; j < pss.length; ++j) {
            ProvidedServiceDescription psd = pss[j];
            List<String> specs = Arrays.asList(psd.getServiceSpecifications());
            if (!specs.containsAll(this.m_specifications)) continue;
            return psd;
        }
        return null;
    }

    private void ensureValidity() {
    }

    private String getSpecificationsArray() {
        if (this.m_specifications.size() == 1) {
            return (String)this.m_specifications.get(0);
        }
        StringBuffer buffer = new StringBuffer("{");
        for (int i = 0; i < this.m_specifications.size(); ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append(this.m_specifications.get(i));
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Service addProperty(ServiceProperty ps) {
        this.m_properties.add(ps);
        return this;
    }

    public Service addProperty(String key, Object obj) {
        Class clazz = class$java$lang$String == null ? (class$java$lang$String = Service.class$("java.lang.String")) : class$java$lang$String;
        String value = null;
        if (obj != null) {
            clazz = obj.getClass();
            value = obj.toString();
        }
        this.addProperty(new ServiceProperty().setName(key).setType(clazz.getName()).setValue(value));
        return this;
    }

    public Service setSpecification(String spec) {
        this.m_specifications = new ArrayList(1);
        this.m_specifications.add(spec);
        return this;
    }

    public Service setSpecifications(List specs) {
        this.m_specifications = specs;
        return this;
    }

    public Service setCreationStrategy(int strategy) {
        this.m_strategy = strategy;
        return this;
    }

    public Service setCreationStrategy(String strategy) {
        this.m_strategy = -1;
        this.m_customStrategy = strategy;
        return this;
    }

    public Service setServiceController(String field, boolean initialValue) {
        this.m_controller = field;
        this.m_controllerValue = initialValue;
        return this;
    }

    private String getStringStrategy() {
        switch (this.m_strategy) {
            case -1: {
                return this.m_customStrategy;
            }
            case 0: {
                return "singleton";
            }
            case 2: {
                return "method";
            }
            case 1: {
                return "service";
            }
            case 3: {
                return "instance";
            }
        }
        throw new IllegalStateException("Unknown creation strategy :  " + this.m_strategy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

