/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.car.impl;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.configurator.CarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.car.impl.specific.ISpecificCarDeployableFactory;
import org.ow2.util.ee.metadata.car.impl.xml.merge.CarMetadataMerge;
import org.ow2.util.ee.metadata.car.impl.xml.parsing.CARDeploymentDescLoader;
import org.ow2.util.ee.metadata.car.impl.xml.struct.CAR;
import org.ow2.util.ee.metadata.common.impl.AbsDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.classlocator.ArchiveClassesLocator;
import org.ow2.util.scan.api.classlocator.ClassLoaderClassesLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarDeployableMetadataFactory
extends AbsDeployableMetadataFactory
implements ICarDeployableMetadataFactory {
    private static final Log LOGGER = LogFactory.getLog(CarDeployableMetadataFactory.class);
    private static final String APPLICATION_CLIENT = "META-INF/application-client.xml";

    public CarDeployableMetadataFactory() {
    }

    public CarDeployableMetadataFactory(IScanner scanner) {
        super(scanner);
    }

    public ICarDeployableMetadata createDeployableMetadata(CARDeployable deployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(deployable, Arrays.asList(new ClassLoaderClassesLocator(ClassLoader.getSystemClassLoader())), null);
    }

    public ICarDeployableMetadata createDeployableMetadata(CARDeployable deployable, ClassLoader classLoader) throws DeployableMetadataException {
        List<ClassLoaderClassesLocator> classesLocatorList = null;
        classesLocatorList = classLoader != null ? Arrays.asList(new ClassLoaderClassesLocator(classLoader)) : Arrays.asList(new ClassLoaderClassesLocator(ClassLoader.getSystemClassLoader()));
        return this.createDeployableMetadata(deployable, classesLocatorList, null);
    }

    private void completeClassList(CAR car, Set<String> classNameSet) {
        if (car != null) {
            this.addClassToSetIfNotNull(car.getCallbackHandler(), classNameSet);
        }
    }

    public ICarDeployableMetadata createDeployableMetadata(CARDeployable deployable, List<? extends IClassesLocator> carExternLibraries, List<? extends ISpecificCarDeployableFactory> specificDeployableFactoryList) throws DeployableMetadataException {
        Iterator entryIterator;
        URL applicationClientURL;
        long tAnalyzeStart = System.currentTimeMillis();
        IArchive archive = deployable.getArchive();
        CAR car = null;
        try {
            applicationClientURL = archive.getResource(APPLICATION_CLIENT);
        }
        catch (ArchiveException e) {
            throw new DeployableMetadataException("Unable to get DD URL", (Throwable)e);
        }
        if (applicationClientURL != null) {
            try {
                car = CARDeploymentDescLoader.loadDeploymentDescriptor(applicationClientURL);
            }
            catch (ParsingException e) {
                throw new DeployableMetadataException("Unable to parse DD URL", (Throwable)e);
            }
        }
        CarDeployableMetadataConfigurator carArchiveMetadataConfigurator = new CarDeployableMetadataConfigurator(deployable);
        HashSet<String> classNameSet = new HashSet<String>();
        if (specificDeployableFactoryList != null) {
            for (ISpecificCarDeployableFactory iSpecificCarDeployableFactory : specificDeployableFactoryList) {
                carArchiveMetadataConfigurator.addSpecificMetadataConfigurator(iSpecificCarDeployableFactory.beforeScan(deployable, classNameSet));
            }
        }
        if (car != null && car.isMetadataComplete()) {
            carArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        } else {
            carArchiveMetadataConfigurator.setAnnotationParsingDesactived(false);
        }
        try {
            entryIterator = archive.getEntries();
        }
        catch (ArchiveException archiveException) {
            throw new DeployableMetadataException((Throwable)archiveException);
        }
        while (entryIterator.hasNext()) {
            String string = (String)entryIterator.next();
            if (!string.endsWith(".class")) continue;
            classNameSet.add(string.substring(0, string.length() - ".class".length()));
        }
        this.completeClassList(car, classNameSet);
        this.scan(classNameSet, (IClassesLocator)new ArchiveClassesLocator(archive), carExternLibraries, carArchiveMetadataConfigurator);
        CarDeployableMetadata carDeployableMetadata = carArchiveMetadataConfigurator.getCarDeployableMetadata();
        if (car != null) {
            carDeployableMetadata.setMetadataComplete(car.isMetadataComplete());
        }
        if (car != null) {
            new CarMetadataMerge(carDeployableMetadata).merge(car);
        }
        if (LOGGER.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            LOGGER.debug((Object)"Analyze of file {0} took {1} ms.", new Object[]{archive.getName(), tAnalyzeStartEnd - tAnalyzeStart});
        }
        return carDeployableMetadata;
    }

    public Class<ICarDeployableMetadata> getDeployableMetadataClass() {
        return ICarDeployableMetadata.class;
    }
}

