/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.enc.java;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.carol.jndi.enc.java.CompNamingContext;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaURLContext
implements Context {
    private static final String URL_PREFIX = "java:";
    private Hashtable<Object, Object> myEnv = null;
    private static Hashtable<ClassLoader, Context> clBindings = new Hashtable();
    private static ThreadLocal<Context> threadContext = new ThreadLocal();

    public JavaURLContext(Hashtable<?, ?> env) {
        if (env != null) {
            this.myEnv = new Hashtable(env);
        }
    }

    private String getRelativeName(String name) throws NamingException {
        if (!name.startsWith(URL_PREFIX)) {
            TraceCarol.error("relative name! :" + name);
            throw new NameNotFoundException("Invalid name:" + name);
        }
        name = name.endsWith("/") ? name.substring(URL_PREFIX.length(), name.length() - 1) : name.substring(URL_PREFIX.length());
        return name;
    }

    private Name getRelativeName(Name name) throws NamingException {
        if (name.get(0).equals(URL_PREFIX)) {
            return name.getSuffix(1);
        }
        TraceCarol.error("relative name! :" + name);
        throw new NameNotFoundException("Invalid name:" + name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.findContext().lookup(this.getRelativeName(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.findContext().lookup(this.getRelativeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.findContext().bind(this.getRelativeName(name), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.findContext().bind(this.getRelativeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.findContext().rebind(this.getRelativeName(name), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.findContext().rebind(this.getRelativeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.findContext().unbind(this.getRelativeName(name));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.findContext().unbind(this.getRelativeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.findContext().rename(this.getRelativeName(oldName), this.getRelativeName(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.findContext().rename(this.getRelativeName(oldName), this.getRelativeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.findContext().list(this.getRelativeName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.findContext().list(this.getRelativeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.findContext().listBindings(this.getRelativeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.findContext().listBindings(this.getRelativeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.findContext().destroySubcontext(this.getRelativeName(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.findContext().destroySubcontext(this.getRelativeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.findContext().createSubcontext(this.getRelativeName(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.findContext().createSubcontext(this.getRelativeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.findContext().lookupLink(this.getRelativeName(name));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.findContext().lookupLink(this.getRelativeName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.findContext().getNameParser(this.getRelativeName(name));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.findContext().getNameParser(this.getRelativeName(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)name.clone();
        return prefix.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.findContext().addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.findContext().removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.findContext().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.findContext().close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return URL_PREFIX;
    }

    public Context findContext() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Context ctx = null;
        if (cl != null && cl.getParent() != null) {
            ctx = clBindings.get(cl.getParent());
            if (ctx != null) {
                return ctx;
            }
            ctx = this.buildNewContext(cl.getParent().toString());
            clBindings.put(cl.getParent(), ctx);
        }
        if (ctx == null && (ctx = threadContext.get()) == null) {
            ctx = this.buildNewContext(threadContext.toString());
        }
        return ctx;
    }

    private Context buildNewContext(String name) {
        return new CompNamingContext(name, new Hashtable<Object, Object>(this.myEnv));
    }
}

