/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.commands.util;

import org.apache.felix.service.command.CommandSession;

public class NameScoping {
    public static final String MULTI_SCOPE_MODE_KEY = "MULTI_SCOPE_MODE";

    public static String getCommandNameWithoutGlobalPrefix(CommandSession session, String key) {
        String prefix;
        String globalScope;
        if (!NameScoping.isMultiScopeMode(session) && (globalScope = (String)session.get("APPLICATION")) != null && key.startsWith(prefix = globalScope + ":")) {
            return key.substring(prefix.length());
        }
        return key;
    }

    public static boolean isGlobalScope(CommandSession session, String scope) {
        String globalScope;
        if (!NameScoping.isMultiScopeMode(session) && (globalScope = (String)session.get("APPLICATION")) != null) {
            return scope.equals(globalScope);
        }
        return false;
    }

    public static boolean isMultiScopeMode(CommandSession session) {
        Object value = session.get(MULTI_SCOPE_MODE_KEY);
        return value == null || !value.equals("false");
    }
}

