/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.console;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import jline.Terminal;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiRenderer;
import org.ow2.shelbie.core.ExitSessionException;
import org.ow2.shelbie.core.branding.BrandingService;
import org.ow2.shelbie.core.console.util.Streams;
import org.ow2.shelbie.core.internal.handler.completer.ScopeCompleter;
import org.ow2.shelbie.core.internal.handler.completer.ShelbieCandidateListCompletionHandler;
import org.ow2.shelbie.core.prompt.PromptService;
import org.ow2.shelbie.core.prompt.Variables;

public class JLineConsole
implements Runnable {
    private CommandSession session;
    private ConsoleReader reader;
    private boolean running = true;
    private PromptService promptService;
    private Variables sessionVariables = new SessionVariables();
    private FileHistory history;
    private BrandingService brandingService;
    private Runnable callback;

    public JLineConsole(CommandProcessor processor, Completer completer, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        PrintStream wrappedOut = Streams.wrap(out);
        PrintStream wrappedErr = Streams.wrap(err);
        this.reader = new ConsoleReader(in, wrappedOut, terminal);
        this.reader.setHandleUserInterrupt(true);
        this.reader.setCompletionHandler(new ShelbieCandidateListCompletionHandler());
        this.session = processor.createSession(in, wrappedOut, wrappedErr);
        AggregateCompleter composite = new AggregateCompleter(completer, new ScopeCompleter(completer, this.session));
        this.reader.addCompleter(composite);
        this.session.put(ConsoleReader.class.getName(), (Object)this.reader);
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    public void setPromptService(PromptService promptService) {
        this.promptService = promptService;
    }

    public void setHistoryFile(File historyFile) {
        if (historyFile != null) {
            try {
                this.history = new FileHistory(historyFile);
                this.reader.setHistory(this.history);
                this.session.put(History.class.getName(), (Object)this.history);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setBrandingService(BrandingService brandingService) {
        this.brandingService = brandingService;
    }

    public CommandSession getSession() {
        return this.session;
    }

    public void close() {
        if (this.history != null) {
            try {
                this.history.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.running = false;
        this.reader.shutdown();
    }

    public void run() {
        if (this.brandingService != null) {
            this.doSessionBranding();
        }
        while (this.running) {
            try {
                String rendered = this.getRenderedPrompt();
                String line = this.reader.readLine(rendered);
                if (line == null) {
                    this.session.getConsole().printf("%n^D%n", new Object[0]);
                    this.running = false;
                    continue;
                }
                Object result = this.session.execute((CharSequence)line);
                this.session.put("_", result);
                if (result == null) continue;
                CharSequence value = this.session.format(result, 0);
                this.session.getConsole().println(value);
            }
            catch (ExitSessionException e) {
                this.running = false;
            }
            catch (UserInterruptException uie) {
                this.session.getConsole().println("^C");
            }
            catch (IOException ioe) {
                this.running = false;
            }
            catch (Throwable t) {
                this.session.put("exception", (Object)t);
                this.printError(t.getClass().getSimpleName(), t.getMessage());
            }
        }
        if (this.callback != null) {
            this.callback.run();
        }
        this.session.close();
    }

    private void doSessionBranding() {
        this.session.getConsole().println(this.brandingService.getBanner(this.reader.getTerminal().isAnsiSupported()));
        for (Map.Entry<String, Object> entry : this.brandingService.getVariables().entrySet()) {
            this.session.put(entry.getKey(), entry.getValue());
        }
        if (this.brandingService.getScript() != null) {
            for (String line : this.brandingService.getScript()) {
                try {
                    Object result = this.session.execute((CharSequence)line);
                    this.session.put("_", result);
                    if (result == null) continue;
                    this.session.getConsole().println(this.session.format(result, 0));
                }
                catch (Exception e) {
                    this.printError(e.getClass().getSimpleName(), e.getMessage());
                }
            }
        }
    }

    private String getRenderedPrompt() {
        String prompt = this.promptService.getPrompt(this.sessionVariables);
        if (AnsiRenderer.test(prompt)) {
            prompt = AnsiRenderer.render(prompt);
        }
        return prompt;
    }

    private void printError(String type, String message) {
        String error = Ansi.ansi().fg(Ansi.Color.RED).a("[").a(type).a("]: ").reset().toString();
        this.session.getConsole().println(error + message);
    }

    private class SessionVariables
    implements Variables {
        private SessionVariables() {
        }

        public Object get(String name) {
            return JLineConsole.this.session.get(name);
        }
    }
}

