/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.log.jul.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JDKFormatter
extends Formatter {
    private static final String PATTERN_DATE_TIME = "{0,date,short} {0,time,medium}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Date date = new Date();

    public synchronized String format(LogRecord logRecord) {
        StringBuilder fullMessage = new StringBuilder();
        this.date.setTime(logRecord.getMillis());
        fullMessage.append(MessageFormat.format(PATTERN_DATE_TIME, this.date));
        fullMessage.append(" (");
        fullMessage.append(logRecord.getLevel().getLocalizedName().substring(0, 1));
        fullMessage.append(") ");
        if (logRecord.getSourceClassName() != null) {
            String[] splitNames = logRecord.getSourceClassName().split("\\.");
            fullMessage.append(splitNames[splitNames.length - 1]);
        } else {
            fullMessage.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            fullMessage.append(".");
            fullMessage.append(logRecord.getSourceMethodName());
        }
        fullMessage.append(" : ");
        String userMessage = this.formatMessage(logRecord);
        fullMessage.append(userMessage);
        fullMessage.append(LINE_SEPARATOR);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                fullMessage.append(stringWriter.toString());
            }
            catch (Exception ex) {
                System.err.println("Formatter error" + ex.getMessage());
            }
        }
        return fullMessage.toString();
    }
}

