/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.Set;
import org.apache.felix.ipojo.manipulation.annotations.CustomAnnotationVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCodeAdapter
extends GeneratorAdapter
implements Opcodes {
    private String m_owner;
    private boolean m_superDetected;
    private String m_superClass;
    private Set<String> m_fields;

    public ConstructorCodeAdapter(MethodVisitor mv, String owner, Set<String> fields, int access, String name, String desc, String superClass) {
        super(mv, access, name, desc);
        this.m_owner = owner;
        this.m_superDetected = false;
        this.m_fields = fields;
        this.m_superClass = superClass;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, boolean visible) {
        if (visible) {
            return null;
        }
        return super.visitAnnotation(name, visible);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Property;") || desc.equals("Lorg/apache/felix/ipojo/annotations/Requires;") || CustomAnnotationVisitor.isCustomAnnotation(desc)) {
            return null;
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.m_fields.contains(name) && this.m_owner.equals(owner)) {
            if (opcode == 180) {
                String gDesc = "()" + desc;
                this.mv.visitMethodInsn(182, owner, "__get" + name, gDesc);
                return;
            }
            if (opcode == 181) {
                String sDesc = "(" + desc + ")V";
                this.mv.visitMethodInsn(182, owner, "__set" + name, sDesc);
                return;
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (!this.m_superDetected && name.equals("<init>") && owner.equals(this.m_superClass)) {
            this.m_superDetected = true;
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitMethodInsn(183, this.m_owner, "_setInstanceManager", "(Lorg/apache/felix/ipojo/InstanceManager;)V");
        } else {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (var == 0) {
            this.mv.visitVarInsn(opcode, var);
        } else {
            this.mv.visitVarInsn(opcode, var + 1);
        }
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        if (var != 0) {
            this.mv.visitIincInsn(var + 1, increment);
        } else {
            this.mv.visitIincInsn(var, increment);
        }
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index == 0) {
            this.mv.visitLocalVariable(name, desc, signature, start, end, index);
            this.mv.visitLocalVariable("_manager", "Lorg/apache/felix/ipojo/InstanceManager;", null, start, end, 1);
        } else {
            this.mv.visitLocalVariable(name, desc, signature, start, end, index + 1);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack + 1, maxLocals + 2);
    }
}

