/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.lib.loader.IMetaInfLocator;

public class OSGiClassLoader
extends URLClassLoader {
    private static final String META_INF = "META-INF";
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private IMetaInfLocator metaInfLocator = null;

    public OSGiClassLoader() {
        super(new URL[0]);
        BundleContext bundleContext;
        ServiceReference serviceReference;
        Bundle bundle = FrameworkUtil.getBundle(OSGiClassLoader.class);
        if (bundle != null && (serviceReference = (bundleContext = bundle.getBundleContext()).getServiceReference(IMetaInfLocator.class.getName())) != null) {
            this.metaInfLocator = (IMetaInfLocator)bundleContext.getService(serviceReference);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean flag) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        if (this.metaInfLocator != null && name.startsWith(META_INF) && (resource = this.metaInfLocator.getResource(name)) != null) {
            return resource;
        }
        try {
            resource = this.classLoader.getResource(name);
        }
        catch (IllegalArgumentException e) {
            try {
                resource = super.getResource(name);
            }
            catch (IllegalArgumentException e2) {
                return resource;
            }
        }
        if (resource == null) {
            resource = super.getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> enumeration = null;
        if (this.metaInfLocator != null && name.startsWith(META_INF) && (enumeration = this.metaInfLocator.getResources(name)) != null) {
            return enumeration;
        }
        try {
            enumeration = this.classLoader.getResources(name);
        }
        catch (IllegalArgumentException e) {
            try {
                enumeration = super.getResources(name);
            }
            catch (IllegalArgumentException e2) {
                return enumeration;
            }
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            enumeration = super.getResources(name);
        }
        return enumeration;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.metaInfLocator != null && name.startsWith(META_INF) && (is = this.metaInfLocator.getResourceAsStream(name)) != null) {
            return is;
        }
        is = this.classLoader.getResourceAsStream(name);
        if (is == null) {
            is = super.getResourceAsStream(name);
        }
        return is;
    }
}

