/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common.lib;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.jonas.deployment.api.DTDs;
import org.ow2.jonas.deployment.api.Schemas;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JEntityResolver
implements EntityResolver {
    private HashMap entries = new HashMap();

    private void addSchema(String path) {
        String id = path.substring(path.lastIndexOf(47) + 1);
        this.entries.put(id, path);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        String localPath = null;
        if (publicId != null) {
            localPath = (String)this.entries.get(publicId);
        } else if (systemId != null && systemId.toLowerCase().endsWith(".xsd")) {
            String baseName = systemId.substring(systemId.lastIndexOf(47) + 1);
            localPath = (String)this.entries.get(baseName);
        }
        if (localPath == null) {
            return null;
        }
        return new InputSource(localPath);
    }

    public void addDtds(DTDs dtds) {
        Map dtdsMapping;
        if (dtds != null && (dtdsMapping = dtds.getMapping()) != null) {
            for (Map.Entry entry : dtdsMapping.entrySet()) {
                String publicId = (String)entry.getKey();
                String localURL = (String)entry.getValue();
                this.entries.put(publicId, localURL);
            }
        }
    }

    public void addSchemas(Schemas schemas) {
        if (schemas == null) {
            return;
        }
        List localSchemas = schemas.getlocalSchemas();
        if (localSchemas != null) {
            for (String schema : localSchemas) {
                this.addSchema(schema);
            }
        }
    }
}

