/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.endpoint.collector.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.endpoint.collector.Endpoint;
import org.ow2.jonas.endpoint.collector.IEndpoint;
import org.ow2.jonas.endpoint.collector.IEndpointBuilder;
import org.ow2.jonas.endpoint.collector.util.Util;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EndpointCollector
extends AbsServiceImpl
implements NotificationListener,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(EndpointCollector.class);
    private boolean __FendpointMap;
    private Map<ObjectName, ServiceRegistration<IEndpoint>> endpointMap;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FmBeanServer;
    private MBeanServer mBeanServer;
    private boolean __FendpointBuilders;
    private List<IEndpointBuilder> endpointBuilders;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MbindJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MunbindJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MhandleNotification$javax_management_Notification$java_lang_Object;
    private boolean __MhandleEndpoint$javax_management_ObjectName;
    private boolean __MgetMBeanAttributeValue$javax_management_ObjectName$java_lang_String;
    private boolean __MgetEndpointBuilder$javax_management_ObjectName;
    private boolean __MbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder;
    private boolean __MunbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder;

    Map __getendpointMap() {
        if (!this.__FendpointMap) {
            return this.endpointMap;
        }
        return (Map)this.__IM.onGet((Object)this, "endpointMap");
    }

    void __setendpointMap(Map map) {
        if (!this.__FendpointMap) {
            this.endpointMap = map;
            return;
        }
        this.__IM.onSet((Object)this, "endpointMap", (Object)map);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    MBeanServer __getmBeanServer() {
        if (!this.__FmBeanServer) {
            return this.mBeanServer;
        }
        return (MBeanServer)this.__IM.onGet((Object)this, "mBeanServer");
    }

    void __setmBeanServer(MBeanServer mBeanServer) {
        if (!this.__FmBeanServer) {
            this.mBeanServer = mBeanServer;
            return;
        }
        this.__IM.onSet((Object)this, "mBeanServer", (Object)mBeanServer);
    }

    List __getendpointBuilders() {
        if (!this.__FendpointBuilders) {
            return this.endpointBuilders;
        }
        return (List)this.__IM.onGet((Object)this, "endpointBuilders");
    }

    void __setendpointBuilders(List list) {
        if (!this.__FendpointBuilders) {
            this.endpointBuilders = list;
            return;
        }
        this.__IM.onSet((Object)this, "endpointBuilders", (Object)list);
    }

    public EndpointCollector(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private EndpointCollector(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setendpointMap(new HashMap());
        this.__setbundleContext(bundleContext);
        this.__setendpointBuilders(new ArrayList());
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        String rmiProtocolPattern;
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        filter.enableAllObjectNames();
        String jmxProtocolPattern = "connectors:protocol=rmi,name=*";
        ObjectName objectName = Util.getObjectName(jmxProtocolPattern);
        if (objectName != null) {
            Set<ObjectName> objectNameSet = this.__getmBeanServer().queryNames(objectName, null);
            for (ObjectName on : objectNameSet) {
                this.handleEndpoint(on);
            }
        }
        if ((objectName = Util.getObjectName(rmiProtocolPattern = this.__getjmxService().getDomainName() + ":j2eeType=JNDIResource,name=*,J2EEServer=" + this.__getjmxService().getJonasServerName())) != null) {
            Set<ObjectName> objectNameSet = this.__getmBeanServer().queryNames(objectName, null);
            for (ObjectName on : objectNameSet) {
                this.handleEndpoint(on);
            }
        }
        try {
            this.__getmBeanServer().addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)filter, null);
        }
        catch (InstanceNotFoundException e) {
            logger.info((Object)("Cannot add notification listener on " + MBeanServerDelegate.DELEGATE_NAME), new Object[]{e});
        }
        logger.info((Object)"Endpoint Collector started.", new Object[0]);
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        try {
            this.__getmBeanServer().removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)("Cannot remove notification listener on " + MBeanServerDelegate.DELEGATE_NAME), new Object[]{e});
        }
        catch (ListenerNotFoundException e) {
            logger.error((Object)("Cannot remove notification listener on " + MBeanServerDelegate.DELEGATE_NAME), new Object[]{e});
        }
        logger.info((Object)"Endpoint Collector stopped.", new Object[0]);
    }

    public void bindJmxService(JmxService jmxService) {
        if (!this.__MbindJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_bindJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_bindJmxService(jmxService);
            this.__IM.onExit((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_bindJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
        this.__setmBeanServer(jmxService.getJmxServer());
    }

    public void unbindJmxService(JmxService jmxService) {
        if (!this.__MunbindJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_unbindJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_unbindJmxService(jmxService);
            this.__IM.onExit((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_unbindJmxService(JmxService jmxService) {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!this.__MhandleNotification$javax_management_Notification$java_lang_Object) {
            this.__M_handleNotification(notification, handback);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handleNotification$javax_management_Notification$java_lang_Object", new Object[]{notification, handback});
            this.__M_handleNotification(notification, handback);
            this.__IM.onExit((Object)this, "handleNotification$javax_management_Notification$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handleNotification$javax_management_Notification$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_handleNotification(Notification notification, Object handback) {
        if (notification != null) {
            if ("JMX.mbean.registered".equals(notification.getType())) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                this.handleEndpoint(objectName);
            } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                ServiceRegistration serviceRegistration = (ServiceRegistration)this.__getendpointMap().get(objectName);
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
            }
        }
    }

    private void handleEndpoint(ObjectName objectName) {
        if (!this.__MhandleEndpoint$javax_management_ObjectName) {
            this.__M_handleEndpoint(objectName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handleEndpoint$javax_management_ObjectName", new Object[]{objectName});
            this.__M_handleEndpoint(objectName);
            this.__IM.onExit((Object)this, "handleEndpoint$javax_management_ObjectName", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handleEndpoint$javax_management_ObjectName", throwable);
            throw throwable;
        }
    }

    private void __M_handleEndpoint(ObjectName objectName) {
        if (objectName != null) {
            IEndpoint endpoint = null;
            Pattern jmxPattern = Pattern.compile("connectors:protocol=rmi,name=.*");
            Pattern rmiPattern = Pattern.compile(".*:j2eeType=JNDIResource,name=.*,J2EEServer=.*");
            if (jmxPattern.matcher(objectName.toString()).matches()) {
                endpoint = new Endpoint();
                Object value = this.getMBeanAttributeValue(objectName, "Address");
                if (value != null) {
                    endpoint.setUrl(String.valueOf(value));
                }
                String protocol = "jmx";
                endpoint.setProtocol("jmx");
                endpoint.setSource("endpoint/jmx");
            } else if (rmiPattern.matcher(objectName.toString()).matches()) {
                endpoint = new Endpoint();
                Object value = this.getMBeanAttributeValue(objectName, "Name");
                if (value != null) {
                    String protocol = String.valueOf(value);
                    endpoint.setProtocol(protocol);
                    endpoint.setSource("endpoint/" + protocol);
                }
                if ((value = this.getMBeanAttributeValue(objectName, "ProviderURL")) != null) {
                    endpoint.setUrl(String.valueOf(value));
                }
            } else {
                IEndpointBuilder endpointBuilder = this.getEndpointBuilder(objectName);
                if (endpointBuilder != null) {
                    endpoint = endpointBuilder.buildEndpoint(objectName);
                }
            }
            if (endpoint != null) {
                this.__getendpointMap().put(objectName, this.__getbundleContext().registerService(IEndpoint.class.getName(), (Object)endpoint, null));
            }
        }
    }

    public Object getMBeanAttributeValue(ObjectName objectName, String attribute) {
        Object object;
        if (!this.__MgetMBeanAttributeValue$javax_management_ObjectName$java_lang_String) {
            return this.__M_getMBeanAttributeValue(objectName, attribute);
        }
        try {
            this.__IM.onEntry((Object)this, "getMBeanAttributeValue$javax_management_ObjectName$java_lang_String", new Object[]{objectName, attribute});
            object = this.__M_getMBeanAttributeValue(objectName, attribute);
            this.__IM.onExit((Object)this, "getMBeanAttributeValue$javax_management_ObjectName$java_lang_String", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMBeanAttributeValue$javax_management_ObjectName$java_lang_String", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_getMBeanAttributeValue(ObjectName objectName, String attribute) {
        return Util.getMBeanAttributeValue(objectName, attribute, this.__getmBeanServer());
    }

    private IEndpointBuilder getEndpointBuilder(ObjectName objectName) {
        IEndpointBuilder iEndpointBuilder;
        if (!this.__MgetEndpointBuilder$javax_management_ObjectName) {
            return this.__M_getEndpointBuilder(objectName);
        }
        try {
            this.__IM.onEntry((Object)this, "getEndpointBuilder$javax_management_ObjectName", new Object[]{objectName});
            iEndpointBuilder = this.__M_getEndpointBuilder(objectName);
            this.__IM.onExit((Object)this, "getEndpointBuilder$javax_management_ObjectName", (Object)iEndpointBuilder);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEndpointBuilder$javax_management_ObjectName", throwable);
            throw throwable;
        }
        return iEndpointBuilder;
    }

    private IEndpointBuilder __M_getEndpointBuilder(ObjectName objectName) {
        for (IEndpointBuilder endpointBuilder : this.__getendpointBuilders()) {
            if (!endpointBuilder.isSupport(objectName)) continue;
            return endpointBuilder;
        }
        return null;
    }

    public void bindEndpointBuilder(IEndpointBuilder endpointBuilder) {
        if (!this.__MbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder) {
            this.__M_bindEndpointBuilder(endpointBuilder);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder", new Object[]{endpointBuilder});
            this.__M_bindEndpointBuilder(endpointBuilder);
            this.__IM.onExit((Object)this, "bindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder", throwable);
            throw throwable;
        }
    }

    private void __M_bindEndpointBuilder(IEndpointBuilder endpointBuilder) {
        this.__getendpointBuilders().add(endpointBuilder);
    }

    public void unbindEndpointBuilder(IEndpointBuilder endpointBuilder) {
        if (!this.__MunbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder) {
            this.__M_unbindEndpointBuilder(endpointBuilder);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder", new Object[]{endpointBuilder});
            this.__M_unbindEndpointBuilder(endpointBuilder);
            this.__IM.onExit((Object)this, "unbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder", throwable);
            throw throwable;
        }
    }

    private void __M_unbindEndpointBuilder(IEndpointBuilder endpointBuilder) {
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("endpointBuilders")) {
                this.__FendpointBuilders = true;
            }
            if (set.contains("endpointMap")) {
                this.__FendpointMap = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("mBeanServer")) {
                this.__FmBeanServer = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("bindJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MbindJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("unbindJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MunbindJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("handleNotification$javax_management_Notification$java_lang_Object")) {
                this.__MhandleNotification$javax_management_Notification$java_lang_Object = true;
            }
            if (set.contains("handleEndpoint$javax_management_ObjectName")) {
                this.__MhandleEndpoint$javax_management_ObjectName = true;
            }
            if (set.contains("getMBeanAttributeValue$javax_management_ObjectName$java_lang_String")) {
                this.__MgetMBeanAttributeValue$javax_management_ObjectName$java_lang_String = true;
            }
            if (set.contains("getEndpointBuilder$javax_management_ObjectName")) {
                this.__MgetEndpointBuilder$javax_management_ObjectName = true;
            }
            if (set.contains("bindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder")) {
                this.__MbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder = true;
            }
            if (set.contains("unbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder")) {
                this.__MunbindEndpointBuilder$org_ow2_jonas_endpoint_collector_IEndpointBuilder = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

