/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.reader;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ReaderValidationEventHandler
implements ValidationEventHandler {
    private static Log logger = LogFactory.getLog(ReaderValidationEventHandler.class);
    private int laxLevel;

    public ReaderValidationEventHandler(int laxLevel) {
        if (laxLevel < 0 || laxLevel > 3) {
            throw new IllegalArgumentException("bad value for laxlevel");
        }
        this.laxLevel = laxLevel;
    }

    public boolean handleEvent(ValidationEvent event) {
        if (this.laxLevel < event.getSeverity()) {
            logger.error((Object)"xml file could not be read, message: {0}", new Object[]{event.getMessage()});
            return false;
        }
        logger.debug((Object)"read error, attempting to continue; message: {0}", new Object[]{event.getMessage()});
        return true;
    }
}

