/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.io.FileInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;

public class RoleBasedAuthorizationModule
implements InvocationHandler {
    private MBeanServer mBeanServer = null;
    private Map<String, MethodType> accessRights = new HashMap<String, MethodType>();

    public static MBeanServerForwarder newProxyInstance(String type, String param) {
        try {
            if ("file".equals(type)) {
                String filename = JProp.getJonasBase() + System.getProperty("file.separator") + param;
                FileInputStream input = new FileInputStream(filename);
                Properties props = new Properties();
                props.load(input);
                input.close();
                return (MBeanServerForwarder)Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), new Class[]{MBeanServerForwarder.class}, (InvocationHandler)new RoleBasedAuthorizationModule(props));
            }
            throw new IllegalArgumentException("Unknown MBeanServerForwarder type: " + type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed creating the MBeanServerForwarder: " + e.getLocalizedMessage());
        }
    }

    private RoleBasedAuthorizationModule(Map<String, String> access) {
        for (String key : access.keySet()) {
            MethodType type;
            String value = access.get(key);
            if ("readonly".equals(value)) {
                type = MethodType.GETTER;
            } else if ("readwrite".equals(value)) {
                type = MethodType.SETTER;
            } else {
                throw new IllegalArgumentException("Unknown access right: " + value + ". Valid values are \"readonly\" and \"readwrite\".");
            }
            this.accessRights.put(key, type);
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.mBeanServer = jmxService.getJmxServer();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, Throwable {
        if (method == null) {
            throw new IllegalArgumentException("Method is null");
        }
        String methodName = method.getName();
        if (methodName == null) {
            throw new IllegalArgumentException("MethodName is null");
        }
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null && "setMBeanServer".equals(methodName)) {
            this.mBeanServer = (MBeanServer)args[0];
            return null;
        }
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBeanServer is null");
        }
        if (subject == null) {
            return method.invoke((Object)this.mBeanServer, args);
        }
        MethodType type = methodName.startsWith("get") || methodName.startsWith("query") || methodName.startsWith("is") || methodName.startsWith("to") || "equals".equals(methodName) || "hashCode".equals(methodName) ? MethodType.GETTER : MethodType.SETTER;
        if (this.canAccess(type, this.getRoles(subject))) {
            try {
                return method.invoke((Object)this.mBeanServer, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw new IllegalAccessException("Access denied for method " + methodName);
    }

    private Set<String> getRoles(Subject subject) {
        HashSet<String> roles = new HashSet<String>();
        for (Group group : subject.getPrincipals(Group.class)) {
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                roles.add(p.getName());
            }
        }
        return roles;
    }

    private boolean canAccess(MethodType type, Set<String> roles) {
        if (type != MethodType.GETTER && type != MethodType.SETTER) {
            throw new IllegalArgumentException("Unknown method type: " + (Object)((Object)type));
        }
        MethodType accessRight = this.accessRights.get("*");
        Iterator<String> iterator = roles.iterator();
        while (iterator.hasNext() && accessRight != MethodType.SETTER) {
            String role = iterator.next();
            MethodType currentAccessRight = this.accessRights.get(role);
            if ((currentAccessRight != MethodType.GETTER || accessRight != null) && currentAccessRight != MethodType.SETTER) continue;
            accessRight = currentAccessRight;
        }
        return accessRight == type || accessRight == MethodType.SETTER;
    }

    private static enum MethodType {
        GETTER,
        SETTER;

    }
}

