/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;
import org.osgi.framework.BundleContext;
import org.ow2.carol.jndi.intercept.spi.InterceptorInitialContextFactory;
import org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory;
import org.ow2.jonas.camel.component.DefaultTraceEventMessageToStringProcessor;
import org.ow2.jonas.camel.component.MessageFormatter;
import org.ow2.jonas.camel.component.ProducerWithCorrectClassLoader;
import org.ow2.jonas.camel.component.RegistryInjector;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RouteBuilderComponent
extends RouteBuilder {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final String TRACE_LOGGER_NAME = "org.ow2.jonas.camel.traces";
    protected BundleContext bundleContext = null;
    protected ICamelService camelService = null;
    protected Map<String, String> registryReplacements = new HashMap<String, String>();
    protected String camelContextName = null;
    protected String traceDestination = null;
    private File conf;

    public RouteBuilderComponent(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        String JONAS_BASE = System.getProperty("jonas.base");
        if (JONAS_BASE == null) {
            throw new RuntimeException("JONAS_BASE not defined");
        }
        this.conf = new File(JONAS_BASE, "conf").getAbsoluteFile();
        MultiOrbInitialContextFactory.class.getClassLoader();
        InterceptorInitialContextFactory.class.getClassLoader();
    }

    public void start() throws Throwable {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.camelContextName = this.camelService.startNewContext();
            CamelContext camelContext = this.camelService.getCamelContext(this.camelContextName);
            RegistryInjector injector = new RegistryInjector(this.registryReplacements);
            this.configureCamelComponents(camelContext, injector.getRegistryFilesContent());
            injector.injectRegistry(this.camelService, this.camelContextName);
            this.camelService.addRoutes((RouteBuilder)this, this.camelContextName);
            this.logger.info("Route " + this.getRouteName() + " has started");
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Cannot start route " + this.getRouteName(), t);
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void stop() throws Throwable {
        try {
            if (this.camelContextName != null) {
                this.camelService.stop(this.camelContextName);
            }
            this.logger.info("Route " + this.getRouteName() + " has stopped");
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Cannot stop route " + this.getRouteName(), t);
            throw t;
        }
        finally {
            this.camelContextName = null;
            this.camelService = null;
            System.gc();
        }
    }

    protected void configureCamelComponents(CamelContext camelContext, List<String> registryFilesContent) throws Exception {
        JmsComponent jms = (JmsComponent)camelContext.getComponent("jms", JmsComponent.class);
        ConnectionFactory connectionFactory = (ConnectionFactory)new InitialContext().lookup("JCF");
        jms.setConnectionFactory(connectionFactory);
        JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
        jndiDestinationResolver.setCache(true);
        jms.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
    }

    public void configure() throws Exception {
        Tracer tracer = new Tracer();
        tracer.setFormatter((TraceFormatter)new MessageFormatter());
        tracer.setLogLevel(LoggingLevel.INFO);
        tracer.setLogName(TRACE_LOGGER_NAME);
        tracer.setTraceExceptions(false);
        if (this.traceDestination != null) {
            tracer.setDestinationUri("direct:traced");
            this.from("direct:traced").process((Processor)new DefaultTraceEventMessageToStringProcessor()).inOnly().process((Processor)new ProducerWithCorrectClassLoader(this.traceDestination));
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
    }

    public void setCamelService(ICamelService camelService) {
        this.camelService = camelService;
    }

    public final File getConfigurationFolder() {
        return this.conf;
    }

    public final String getRouteName() {
        String location = this.bundleContext.getBundle().getLocation();
        int lastSlash = (location = location.replace('\\', '/')).lastIndexOf(47);
        if (lastSlash != -1) {
            location = location.substring(lastSlash + 1);
        }
        if (location.endsWith(".jar")) {
            location = location.substring(0, location.length() - 4);
        }
        return location;
    }

    public File getFileEndpointFile(String url) {
        FileEndpoint endpoint = (FileEndpoint)this.getContext().getEndpoint(url, FileEndpoint.class);
        return endpoint.getFile();
    }
}

