/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProducerWithCorrectClassLoader.java 19784 2010-04-28 17:05:13Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;

/**
 * Camel producer with the TCCL set to the bundle's CL.
 */
public class ProducerWithCorrectClassLoader implements Processor {

    private String to;

    /**
     * @param to Producer's destination.
     */
    public ProducerWithCorrectClassLoader(final String to) {
        this.to = to;
    }

    public void process(final Exchange e) throws Exception {
        final ClassLoader oldCL = Thread.currentThread().getContextClassLoader();

        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Endpoint destination = e.getContext().getEndpoint(this.to);
            Producer producer = destination.createProducer();
            producer.process(e);
        } finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

}
