/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;

public class CamelServlet
implements Servlet {
    private CamelContext camelContext;
    private String camelDestination;
    private ServletConfig servletConfig;

    public CamelServlet(CamelContext camelContext, String camelDestination) {
        this.camelContext = camelContext;
        this.camelDestination = camelDestination;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void service(ServletRequest request, ServletResponse rsp) throws ServletException, IOException {
        block18: {
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                HttpServletResponse response = (HttpServletResponse)rsp;
                Producer producer = this.camelContext.getEndpoint(this.camelDestination).createProducer();
                Exchange exchange = producer.createExchange();
                exchange.getIn().setHeaders(request.getParameterMap());
                exchange.getIn().setBody((Object)request.getInputStream());
                producer.process(exchange);
                String filename = (String)exchange.getOut().getHeader("CamelFileName", String.class);
                if (filename == null) {
                    filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                }
                if (filename != null) {
                    response.setHeader("filename", filename);
                }
                if (exchange.getOut().getBody() == null) {
                    return;
                }
                Object bodyString = exchange.getOut().getBody();
                if (bodyString instanceof String) {
                    response.setContentType("text");
                    response.getWriter().write((String)bodyString);
                    return;
                }
                response.setContentType("application/octet-stream");
                InputStream bodyStream = (InputStream)exchange.getOut().getBody(InputStream.class);
                if (bodyStream != null) {
                    try {
                        int read;
                        while ((read = bodyStream.read()) != -1) {
                            response.getOutputStream().write(read);
                        }
                    }
                    catch (Throwable throwable) {
                        bodyStream.close();
                        Thread.currentThread().setContextClassLoader(oldTCCL);
                        return;
                    }
                    bodyStream.close();
                    return;
                }
                byte[] bodyByteArray = (byte[])exchange.getOut().getBody(byte[].class);
                if (bodyByteArray == null) {
                    throw new NullPointerException("Request body is not a String, InputStream or byte array: " + exchange.getOut().getBody().getClass());
                }
                response.getOutputStream().write(bodyByteArray);
                break block18;
                {
                    catch (Exception e) {
                        throw new ServletException("Cannot create CAMEL exchange", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
    }

    public String getServletInfo() {
        return this.toString();
    }

    public void destroy() {
    }
}

